/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.keyboard.Keystrokes;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.StringResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class CopyToClipboardTest {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String HEADER_TEXT = "Timestamp\tHost\tLogger\tFile\tLine\tMessage" + LINE_SEPARATOR;
    private static final String EVENT1_TEXT = "01:01:01.000 000 000\tHostA\tLoggerA\tSourceFile\t4\tMessage A" + LINE_SEPARATOR;
    private static final String EVENT2_TEXT = "02:02:02.000 000 000\tHostB\tLoggerB\tSourceFile\t5\tMessage B" + LINE_SEPARATOR;
    private static final String EVENT3_TEXT = "03:03:03.000 000 000\tHostC\tLoggerC\tSourceFile\t6\tMessage C" + LINE_SEPARATOR;
    private static final String TRACE_PROJECT_NAME = "test";
    private static final String TRACE_NAME = "syslog_collapse";
    private static final String TRACE_PATH = "testfiles/syslog_collapse";
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog";
    private static final String COPY_TO_CLIPBOARD = "Copy to Clipboard";
    private static final int TIMEOUT = 20000;
    private static File fTestFile = null;
    private static SWTWorkbenchBot fBot;
    private static SWTBotEditor fEditorBot;
    private static final Logger fLogger;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(TRACE_PATH), null);
        try {
            URI uri = FileLocator.toFileURL((URL)location).toURI();
            fTestFile = new File(uri);
        }
        catch (IOException | URISyntaxException e) {
            Assert.fail((String)e.getMessage());
        }
        Assume.assumeTrue((boolean)fTestFile.exists());
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        WaitUtils.waitForJobs();
        SWTBotUtils.createProject(TRACE_PROJECT_NAME);
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, fTestFile.getAbsolutePath(), TRACE_TYPE);
        fEditorBot = SWTBotUtils.activateEditor(fBot, fTestFile.getName());
    }

    @AfterClass
    public static void afterClass() {
        SWTBotUtils.deleteProject(TRACE_PROJECT_NAME, fBot);
        fBot.closeAllEditors();
        SWTBotUtils.closeSecondaryShells(fBot);
        fLogger.removeAllAppenders();
    }

    @Test
    public void testCopySingleSelection() {
        SWTBotTable tableBot = fEditorBot.bot().table();
        tableBot.getTableItem(1).click();
        tableBot.contextMenu(COPY_TO_CLIPBOARD).click();
        CopyToClipboardTest.assertClipboardContentsEquals(String.valueOf(HEADER_TEXT) + EVENT1_TEXT);
    }

    @Test
    public void testCopyMultipleSelection() {
        SWTBotTable tableBot = fEditorBot.bot().table();
        tableBot.getTableItem(1).click();
        tableBot.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.DOWN});
        tableBot.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.DOWN});
        tableBot.contextMenu(COPY_TO_CLIPBOARD).click();
        CopyToClipboardTest.assertClipboardContentsEquals(String.valueOf(HEADER_TEXT) + EVENT1_TEXT + EVENT2_TEXT + EVENT3_TEXT);
    }

    @Test
    public void testNoCopySearchRow() {
        SWTBotTable tableBot = fEditorBot.bot().table();
        tableBot.getTableItem(1).click();
        tableBot.pressShortcut(new KeyStroke[]{Keystrokes.SHIFT, Keystrokes.UP});
        CopyToClipboardTest.assertContextMenuAbsent(tableBot, COPY_TO_CLIPBOARD);
    }

    private static void assertContextMenuAbsent(final SWTBotTable tableBot, final String text) {
        fBot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                try {
                    try {
                        SWTBotPreferences.TIMEOUT = 0L;
                        tableBot.contextMenu(text);
                    }
                    catch (WidgetNotFoundException e) {
                        SWTBotPreferences.TIMEOUT = 20000L;
                        return true;
                    }
                }
                finally {
                    SWTBotPreferences.TIMEOUT = 20000L;
                }
                return false;
            }

            public String getFailureMessage() {
                return String.valueOf(text) + " context menu present, absent expected.";
            }
        });
    }

    private static void assertClipboardContentsEquals(final String expected) {
        fBot.waitUntil((ICondition)new DefaultCondition(){
            String actual;

            public boolean test() throws Exception {
                this.actual = (String)UIThreadRunnable.syncExec((Result)new StringResult(){

                    public String run() {
                        Clipboard clipboard = new Clipboard(Display.getDefault());
                        TextTransfer textTransfer = TextTransfer.getInstance();
                        try {
                            String string = (String)clipboard.getContents((Transfer)textTransfer);
                            return string;
                        }
                        finally {
                            clipboard.dispose();
                        }
                    }
                });
                return expected.equals(this.actual);
            }

            public String getFailureMessage() {
                return NLS.bind((String)"Clipboard contents:\n{0}\nExpected:\n{1}", (Object)this.actual, (Object)expected);
            }
        });
    }
}

