/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.parsers.custom;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.tracecompass.tmf.core.tests.parsers.custom.AbstractCustomTraceIndexTest;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;

public class CustomXmlIndexTest
extends AbstractCustomTraceIndexTest {
    private static final String TRACE_DIRECTORY = String.valueOf(TmfTraceManager.getTemporaryDirPath()) + File.separator + "dummyXmlTrace";
    private static final String TRACE_PATH = String.valueOf(TRACE_DIRECTORY) + File.separator + "test.xml";
    private static final String DEFINITION_PATH = "testfiles" + File.separator + "xml" + File.separator + "testDefinition.xml";

    private static CustomXmlTraceDefinition createDefinition() {
        CustomXmlTraceDefinition[] definitions = CustomXmlTraceDefinition.loadAll((String)new File(DEFINITION_PATH).toString());
        return definitions[0];
    }

    @Override
    protected String getTraceDirectory() {
        return TRACE_DIRECTORY;
    }

    @Override
    protected AbstractCustomTraceIndexTest.TestTrace createTrace() throws Exception {
        CustomXmlTraceDefinition definition = CustomXmlIndexTest.createDefinition();
        File file = new File(TRACE_PATH);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write("<trace>");
            int i = 0;
            while (i < 10000) {
                SimpleDateFormat f = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SSS");
                String eventStr = "<element time=\"" + f.format(new Date(i)) + "\">message</element>\n";
                writer.write(eventStr);
                ++i;
            }
            writer.write("</trace>");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new TestXmlTrace(file.toString(), definition, 100);
    }

    private class TestXmlTrace
    extends CustomXmlTrace
    implements AbstractCustomTraceIndexTest.TestTrace {
        public TestXmlTrace(String path, CustomXmlTraceDefinition createDefinition, int blockSize) throws TmfTraceException {
            super(null, createDefinition, path, blockSize);
        }

        protected ITmfTraceIndexer createIndexer(int interval) {
            return new AbstractCustomTraceIndexTest.TestIndexer(this, interval);
        }

        @Override
        public AbstractCustomTraceIndexTest.TestIndexer getIndexer() {
            return (AbstractCustomTraceIndexTest.TestIndexer)super.getIndexer();
        }
    }
}

