/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.io.ResourceUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ResourceUtilTest {
    @ClassRule
    public static TemporaryFolder fTemporaryFolder = new TemporaryFolder();
    private static TemporaryFolder fProjectFolder = ResourceUtilTest.initStaticTemp();
    private static final boolean IS_LINUX = System.getProperty("os.name").contains("Linux");
    private static final boolean IS_WINDOWS = System.getProperty("os.name").contains("Windows");
    private static final String SOME_PROJECT_NAME = "SomeProject";
    private static final String SOME_OTHER_PROJECT_NAME = "SomeOtherProject";
    private static final String SOME_NEW_PROJECT_NAME = "SomeNewProject";
    private static final String SOME_FOLDER_NAME = "Folder";
    private static final String LINK_TARGET_FILE = "targetFile";
    private static final String LINK_TO_TARGET_FILE = "targetFileLink";
    private static final String LINK_TARGET_FOLDER = "targetFolder";
    private static final String SYMBOLIC_LINK_FILE_NAME = "symbolicLinkFile";
    private static final String TEST_FILE_NAME = "testFile";
    private static final String SYMBOLIC_LINK_FOLDER_NAME = "symbolicLinkFolder";
    private static final String TEST_FOLDER_NAME = "folderFolder";
    private static final String ECLIPSE_LINK_FILE_NAME = "eclipseLinkFile";
    private static final String ECLIPSE_LINK_FOLDER_NAME = "eclipseLinkFolder";
    private static final String COPY_SUFFIX = "_copy";
    private static final String PROPERTY_KEY = "KEY";
    private static final String PROPERTY_VALUE = "VALUE";
    private static IWorkspaceRoot fWorkspaceRoot;
    private static IProject fSomeProject;
    private static IProject fSomeOtherProject;
    private static File fTargetFile;
    private static File fTargetFolder;
    private IProject fTestProject;
    private IFolder fTestFolder;

    @Parameterized.Parameters(name="{index}: ({0})")
    public static Iterable<Object[]> getTracePaths() throws CoreException {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        fWorkspaceRoot = workspace.getRoot();
        fSomeProject = fWorkspaceRoot.getProject(SOME_PROJECT_NAME);
        fSomeProject.create((IProgressMonitor)progressMonitor);
        fSomeProject.open((IProgressMonitor)progressMonitor);
        URI projectLocation = fProjectFolder.getRoot().toURI();
        fSomeOtherProject = fWorkspaceRoot.getProject(SOME_OTHER_PROJECT_NAME);
        IProjectDescription description = workspace.newProjectDescription(fSomeOtherProject.getName());
        if (projectLocation != null) {
            description.setLocationURI(projectLocation);
        }
        fSomeOtherProject.create(description, (IProgressMonitor)progressMonitor);
        fSomeOtherProject.open((IProgressMonitor)progressMonitor);
        return Arrays.asList({fSomeProject}, {fSomeOtherProject});
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        fTargetFile = fTemporaryFolder.newFile(LINK_TARGET_FILE).getCanonicalFile();
        fTargetFolder = fTemporaryFolder.newFolder(LINK_TARGET_FOLDER).getCanonicalFile();
    }

    @AfterClass
    public static void afterClass() throws CoreException {
        if (fSomeProject != null) {
            fSomeProject.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (fSomeOtherProject != null) {
            fSomeOtherProject.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (fProjectFolder != null) {
            fProjectFolder.delete();
        }
    }

    private static TemporaryFolder initStaticTemp() {
        try {
            return new TemporaryFolder(){
                {
                    this.before();
                }
            };
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public ResourceUtilTest(IProject project) throws CoreException {
        this.fTestProject = project;
        this.fTestFolder = project.getFolder(SOME_FOLDER_NAME);
        if (!this.fTestFolder.exists()) {
            this.fTestFolder.create(true, true, null);
        }
    }

    @Test
    public void testCreateSymbolicLink() throws IOException, CoreException {
        java.nio.file.Path linkPath;
        Path path = new Path(fTargetFile.getAbsolutePath());
        boolean isSymLink = !IS_WINDOWS;
        this.createAndVerifyLink((IPath)path, SYMBOLIC_LINK_FILE_NAME, true, isSymLink);
        this.createAndVerifyLink((IPath)path, ECLIPSE_LINK_FILE_NAME, true, false);
        IResource res1 = this.createAndVerifyLink((IPath)path, SYMBOLIC_LINK_FILE_NAME, true, isSymLink);
        this.createAndVerifyLink((IPath)path, ECLIPSE_LINK_FILE_NAME, true, false);
        IResource res2 = this.createAndVerifyLink((IPath)path, ECLIPSE_LINK_FILE_NAME, true, isSymLink, false);
        fTargetFile.delete();
        this.fTestFolder.refreshLocal(1, null);
        IFile file6 = this.fTestFolder.getFile(SYMBOLIC_LINK_FILE_NAME);
        Assert.assertNotNull((Object)file6);
        Assert.assertEquals((Object)IS_WINDOWS, (Object)file6.exists());
        boolean success = ResourceUtil.createSymbolicLink((IResource)file6, (IPath)path, (boolean)true, null);
        Assert.assertTrue((boolean)success);
        Assert.assertTrue((this.isFileSystemSymbolicLink((IResource)file6) == isSymLink ? 1 : 0) != 0);
        Assert.assertEquals((Object)IS_WINDOWS, (Object)file6.isLinked());
        fTargetFile = fTemporaryFolder.newFile(LINK_TARGET_FILE).getCanonicalFile();
        if (IS_LINUX) {
            java.nio.file.Path targetPath = Paths.get(path.toOSString(), new String[0]);
            linkPath = Paths.get(fTemporaryFolder.getRoot().getCanonicalPath(), LINK_TO_TARGET_FILE);
            Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
            path = new Path(linkPath.toString());
            IResource res4 = this.createAndVerifyLink((IPath)path, LINK_TO_TARGET_FILE, true, true);
            res4.delete(true, null);
            Files.delete(linkPath);
        }
        res1.delete(true, null);
        res2.delete(true, null);
        file6.delete(true, null);
        path = new Path(fTargetFolder.getAbsolutePath());
        this.createAndVerifyLink((IPath)path, SYMBOLIC_LINK_FOLDER_NAME, false, isSymLink);
        this.createAndVerifyLink((IPath)path, ECLIPSE_LINK_FOLDER_NAME, false, false);
        res1 = this.createAndVerifyLink((IPath)path, SYMBOLIC_LINK_FOLDER_NAME, false, isSymLink);
        this.createAndVerifyLink((IPath)path, ECLIPSE_LINK_FOLDER_NAME, false, false);
        res2 = this.createAndVerifyLink((IPath)path, ECLIPSE_LINK_FOLDER_NAME, false, isSymLink, false);
        res1.delete(true, null);
        res2.delete(true, null);
        Assert.assertFalse((boolean)ResourceUtil.createSymbolicLink((IResource)((IResource)NonNullUtils.checkNotNull((Object)this.fTestProject)), (IPath)path, (boolean)true, null));
        Assert.assertFalse((boolean)ResourceUtil.createSymbolicLink((IResource)((IResource)NonNullUtils.checkNotNull((Object)this.fTestFolder)), null, (boolean)true, null));
        path = new Path(fTargetFile.getAbsolutePath());
        IResource resource = this.createAndVerifyResource(SYMBOLIC_LINK_FILE_NAME, true);
        success = ResourceUtil.createSymbolicLink((IResource)resource, (IPath)path, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)success);
        success = ResourceUtil.createSymbolicLink((IResource)resource, (IPath)path, (boolean)false, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)success);
        resource.delete(true, null);
        linkPath = Paths.get(this.fTestFolder.getLocation().append(SYMBOLIC_LINK_FOLDER_NAME).toOSString(), new String[0]);
        Files.createDirectory(linkPath, new FileAttribute[0]);
        IFolder folder = this.fTestFolder.getFolder(SYMBOLIC_LINK_FOLDER_NAME);
        Assert.assertNotNull((Object)folder);
        path = new Path(fTargetFolder.getAbsolutePath());
        success = ResourceUtil.createSymbolicLink((IResource)folder, (IPath)path, (boolean)true, null);
        Assert.assertFalse((boolean)success);
        success = ResourceUtil.createSymbolicLink((IResource)folder, (IPath)path, (boolean)false, null);
        Assert.assertFalse((boolean)success);
        Files.delete(linkPath);
    }

    @Test
    public void testDeleteResource() throws IOException, CoreException {
        Path path = new Path(fTargetFile.getAbsolutePath());
        boolean isSymLink = !IS_WINDOWS;
        this.deleteLinkAndVerify((IPath)path, SYMBOLIC_LINK_FILE_NAME, true, isSymLink);
        this.deleteLinkAndVerify((IPath)path, ECLIPSE_LINK_FILE_NAME, true, false);
        path = new Path(fTargetFolder.getAbsolutePath());
        this.deleteLinkAndVerify((IPath)path, SYMBOLIC_LINK_FOLDER_NAME, false, isSymLink);
        this.deleteLinkAndVerify((IPath)path, ECLIPSE_LINK_FOLDER_NAME, false, false);
        IResource resource = this.createAndVerifyResource(TEST_FILE_NAME, true);
        ResourceUtil.deleteResource((IResource)resource, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)resource.exists());
        resource = this.createAndVerifyResource(TEST_FOLDER_NAME, false);
        ResourceUtil.deleteResource((IResource)resource, null);
        Assert.assertFalse((boolean)resource.exists());
        path = new Path(fTargetFile.getAbsolutePath());
        IResource res = this.createAndVerifyLink((IPath)path, SYMBOLIC_LINK_FILE_NAME, true, isSymLink);
        fTargetFile.delete();
        this.fTestFolder.refreshLocal(1, null);
        ResourceUtil.deleteResource((IResource)res, null);
        Assert.assertFalse((boolean)res.exists());
        fTargetFile = fTemporaryFolder.newFile(LINK_TARGET_FILE).getCanonicalFile();
        path = new Path(fTargetFolder.getAbsolutePath());
        res = this.createAndVerifyLink((IPath)path, SYMBOLIC_LINK_FOLDER_NAME, false, isSymLink);
        fTargetFolder.delete();
        this.fTestFolder.refreshLocal(1, null);
        ResourceUtil.deleteResource((IResource)res, null);
        Assert.assertFalse((boolean)res.exists());
        fTargetFolder = fTemporaryFolder.newFolder(LINK_TARGET_FOLDER).getCanonicalFile();
        ResourceUtil.deleteResource(null, null);
        IProject otherProject = fWorkspaceRoot.getProject(SOME_NEW_PROJECT_NAME);
        otherProject.create(null);
        otherProject.open(null);
        String location = otherProject.getLocation().toOSString();
        ResourceUtil.deleteResource((IResource)otherProject, null);
        java.nio.file.Path otherPath = Paths.get(location, new String[0]);
        Assert.assertFalse((boolean)Files.exists(otherPath, new LinkOption[0]));
    }

    @Test
    public void testCopyResource() throws IOException, CoreException {
        Path path = new Path(fTargetFile.getAbsolutePath());
        boolean isSymLink = !IS_WINDOWS;
        this.createLinkCopyAndVerify((IPath)path, SYMBOLIC_LINK_FILE_NAME, true, isSymLink, true);
        this.createLinkCopyAndVerify((IPath)path, SYMBOLIC_LINK_FILE_NAME, true, isSymLink, true, false);
        this.createLinkCopyAndVerify((IPath)path, SYMBOLIC_LINK_FILE_NAME, true, isSymLink, false);
        this.createLinkCopyAndVerify((IPath)path, ECLIPSE_LINK_FILE_NAME, true, false, true);
        this.createLinkCopyAndVerify((IPath)path, ECLIPSE_LINK_FILE_NAME, true, false, false);
        path = new Path(fTargetFolder.getAbsolutePath());
        this.createLinkCopyAndVerify((IPath)path, SYMBOLIC_LINK_FOLDER_NAME, false, isSymLink, true);
        this.createLinkCopyAndVerify((IPath)path, SYMBOLIC_LINK_FOLDER_NAME, false, isSymLink, true, false);
        this.createLinkCopyAndVerify((IPath)path, SYMBOLIC_LINK_FOLDER_NAME, false, isSymLink, false);
        this.createCopyAndVerifyResource(TEST_FILE_NAME, true);
        this.createCopyAndVerifyResource(TEST_FOLDER_NAME, false);
        this.createCopyAndVerifyResource(TEST_FILE_NAME, true, false);
        ResourceUtil.copyResource(null, null, (int)0, null);
        ResourceUtil.copyResource((IResource)this.fTestFolder, null, (int)0, null);
        path = new Path(SOME_NEW_PROJECT_NAME);
        IResource proj = ResourceUtil.copyResource((IResource)this.fTestProject, (IPath)path, (int)1, null);
        Assert.assertNotNull((Object)proj);
        Assert.assertTrue((boolean)(proj instanceof IProject));
        ((IProject)proj).delete(true, true, null);
    }

    @Test
    public void testIsSymbolicLink() throws CoreException {
        IResource resource = this.createAndVerifyResource(TEST_FILE_NAME, true);
        Assert.assertFalse((boolean)ResourceUtil.isSymbolicLink((IResource)resource));
        resource.delete(true, null);
        resource = this.createAndVerifyResource(TEST_FOLDER_NAME, false);
        Assert.assertFalse((boolean)ResourceUtil.isSymbolicLink((IResource)resource));
        resource.delete(true, null);
        Assert.assertFalse((boolean)ResourceUtil.isSymbolicLink(null));
    }

    @Test
    public void testDeleteIfBrokenSymbolicLink() throws IOException, CoreException {
        IResource resource = this.createAndVerifyResource(TEST_FILE_NAME, true);
        ResourceUtil.deleteIfBrokenSymbolicLink((IResource)resource);
        Assert.assertTrue((boolean)resource.exists());
        resource.delete(true, null);
        Path path = new Path(fTargetFile.getAbsolutePath());
        boolean isSymLink = !IS_WINDOWS;
        resource = this.createAndVerifyLink((IPath)path, SYMBOLIC_LINK_FILE_NAME, true, isSymLink);
        ResourceUtil.deleteIfBrokenSymbolicLink((IResource)resource);
        Assert.assertTrue((boolean)resource.exists());
        fTargetFile.delete();
        this.fTestFolder.refreshLocal(1, null);
        ResourceUtil.deleteIfBrokenSymbolicLink((IResource)resource);
        Assert.assertFalse((boolean)resource.exists());
        fTargetFile = fTemporaryFolder.newFile(LINK_TARGET_FILE).getCanonicalFile();
        resource = this.createAndVerifyLink((IPath)path, ECLIPSE_LINK_FILE_NAME, true, false);
        ResourceUtil.deleteIfBrokenSymbolicLink((IResource)resource);
        Assert.assertTrue((boolean)resource.exists());
        fTargetFile.delete();
        ResourceUtil.deleteIfBrokenSymbolicLink((IResource)resource);
        Assert.assertFalse((boolean)resource.exists());
        fTargetFile = fTemporaryFolder.newFile(LINK_TARGET_FILE).getCanonicalFile();
    }

    @Test
    public void testGetLocation() throws IOException, CoreException {
        IResource resource = this.createAndVerifyResource(TEST_FILE_NAME, true);
        ResourceUtilTest.verifyLocation(resource.getLocation(), resource);
        resource.delete(true, null);
        resource = this.createAndVerifyResource(TEST_FOLDER_NAME, false);
        ResourceUtilTest.verifyLocation(resource.getLocation(), resource);
        resource.delete(true, null);
        Assert.assertNull((Object)ResourceUtil.getLocation(null));
    }

    @Test
    public void testGetLocationUri() {
        Assert.assertNull((Object)ResourceUtil.getLocationURI(null));
    }

    private @NonNull IResource createAndVerifyLink(IPath path, String name, boolean isFile, boolean isSymLink) throws IOException, CoreException {
        return this.createAndVerifyLink(path, name, isFile, isSymLink, true);
    }

    private @NonNull IResource createAndVerifyLink(IPath path, String name, boolean isFile, boolean isSymLink, boolean checkSymLink) throws IOException, CoreException {
        Object resource = isFile ? this.fTestFolder.getFile(name) : this.fTestFolder.getFolder(name);
        Assert.assertNotNull((Object)resource);
        boolean success = ResourceUtil.createSymbolicLink((IResource)resource, (IPath)path, (boolean)isSymLink, null);
        Assert.assertTrue((boolean)success);
        Assert.assertTrue((boolean)resource.exists());
        Assert.assertTrue((this.isFileSystemSymbolicLink((IResource)resource) == (checkSymLink ? isSymLink : false) ? 1 : 0) != 0);
        Assert.assertTrue((resource.isLinked() == (checkSymLink ? !isSymLink : true) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ResourceUtil.isSymbolicLink((IResource)resource));
        ResourceUtilTest.verifyLocation(path, (IResource)resource);
        return resource;
    }

    private void createCopyAndVerifyResource(String name, boolean isFile) throws CoreException {
        this.createCopyAndVerifyResource(name, isFile, true);
    }

    private void createCopyAndVerifyResource(String name, boolean isFile, boolean isAbsolute) throws CoreException {
        IResource resource = this.createAndVerifyResource(name, true);
        IPath newPath = isAbsolute ? resource.getParent().getFullPath().addTrailingSeparator().append(String.valueOf(name) + COPY_SUFFIX) : new Path("..").append(resource.getParent().getName()).append(String.valueOf(name) + COPY_SUFFIX);
        resource.setPersistentProperty(new QualifiedName("org.eclipse.tracecompass.tmf.core", PROPERTY_KEY), PROPERTY_VALUE);
        IResource copyResource = ResourceUtil.copyResource((IResource)resource, (IPath)newPath, (int)1, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)copyResource);
        Map persistentProperties = copyResource.getPersistentProperties();
        Assert.assertEquals((long)1L, (long)persistentProperties.size());
        for (Map.Entry entry : persistentProperties.entrySet()) {
            Assert.assertEquals((Object)PROPERTY_KEY, (Object)((QualifiedName)entry.getKey()).getLocalName());
            Assert.assertEquals((Object)"org.eclipse.tracecompass.tmf.core", (Object)((QualifiedName)entry.getKey()).getQualifier());
            Assert.assertEquals((Object)PROPERTY_VALUE, entry.getValue());
        }
        resource.delete(true, null);
        copyResource.delete(true, null);
    }

    private @NonNull IResource createAndVerifyResource(String name, boolean isFile) throws CoreException {
        IFile resource;
        if (isFile) {
            resource = this.fTestFolder.getFile(name);
            resource.create((InputStream)new ByteArrayInputStream(new byte[0]), false, (IProgressMonitor)new NullProgressMonitor());
        } else {
            resource = this.fTestFolder.getFolder(name);
            ((IFolder)resource).create(true, true, null);
        }
        Assert.assertNotNull((Object)resource);
        Assert.assertTrue((boolean)resource.exists());
        return resource;
    }

    private static void verifyLocation(IPath path, IResource resource) throws IOException {
        String osString = path.toOSString();
        if (Files.isSymbolicLink(Paths.get(osString, new String[0]))) {
            Path myPath = new Path(Files.readSymbolicLink(Paths.get(osString, new String[0])).toString());
            Assert.assertEquals((Object)new Path(Files.readSymbolicLink(Paths.get(osString, new String[0])).toString()), (Object)ResourceUtil.getLocation((IResource)resource));
            URI uri = ResourceUtil.getLocationURI((IResource)resource);
            Assert.assertNotNull((Object)uri);
            Assert.assertEquals((Object)myPath, (Object)new Path(uri.getRawPath()));
        } else {
            Assert.assertEquals((Object)path, (Object)ResourceUtil.getLocation((IResource)resource));
            URI uri = ResourceUtil.getLocationURI((IResource)resource);
            Assert.assertNotNull((Object)uri);
            Assert.assertEquals((Object)path, (Object)new Path(uri.getRawPath()));
        }
    }

    private void deleteLinkAndVerify(IPath path, String name, boolean isFile, boolean isSymLink) throws IOException, CoreException {
        IResource resource = this.createAndVerifyLink(path, name, isFile, isSymLink);
        ResourceUtil.deleteResource((IResource)resource, null);
        Assert.assertFalse((boolean)resource.exists());
    }

    private void createLinkCopyAndVerify(IPath path, String name, boolean isFile, boolean isSymLink, boolean isShallow) throws IOException, CoreException {
        this.createLinkCopyAndVerify(path, name, isFile, isSymLink, isShallow, true);
    }

    private void createLinkCopyAndVerify(IPath path, String name, boolean isFile, boolean isSymLink, boolean isShallow, boolean isAbsolute) throws IOException, CoreException {
        IResource originialResource = this.createAndVerifyLink(path, name, isFile, isSymLink);
        originialResource.setPersistentProperty(new QualifiedName("org.eclipse.tracecompass.tmf.core", PROPERTY_KEY), PROPERTY_VALUE);
        IPath newPath = isAbsolute ? originialResource.getParent().getFullPath().addTrailingSeparator().append(String.valueOf(name) + COPY_SUFFIX) : new Path("..").append(originialResource.getParent().getName()).append(String.valueOf(name) + COPY_SUFFIX);
        int flags = 1;
        IResource copyResource = ResourceUtil.copyResource((IResource)originialResource, (IPath)((IPath)NonNullUtils.checkNotNull((Object)newPath)), (int)(flags |= isShallow ? 32 : 0), null);
        Assert.assertNotNull((Object)copyResource);
        Assert.assertTrue((boolean)copyResource.exists());
        Assert.assertTrue((this.isFileSystemSymbolicLink(copyResource) == (isSymLink && isShallow) ? 1 : 0) != 0);
        Assert.assertTrue((copyResource.isLinked() == (!isSymLink && isShallow) ? 1 : 0) != 0);
        Assert.assertTrue((ResourceUtil.isSymbolicLink((IResource)copyResource) == (isSymLink && isShallow || !isSymLink && isShallow) ? 1 : 0) != 0);
        Map persistentProperties = copyResource.getPersistentProperties();
        Assert.assertEquals((long)1L, (long)persistentProperties.size());
        for (Map.Entry entry : persistentProperties.entrySet()) {
            Assert.assertEquals((Object)PROPERTY_KEY, (Object)((QualifiedName)entry.getKey()).getLocalName());
            Assert.assertEquals((Object)"org.eclipse.tracecompass.tmf.core", (Object)((QualifiedName)entry.getKey()).getQualifier());
            Assert.assertEquals((Object)PROPERTY_VALUE, entry.getValue());
        }
        originialResource.delete(true, null);
        copyResource.delete(true, null);
    }

    boolean isFileSystemSymbolicLink(IResource resource) {
        return Files.isSymbolicLink(Paths.get(resource.getLocationURI()));
    }
}

