/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.junit.Assert;
import org.junit.Test;

public class TmfEventTypeTest {
    private final @NonNull String fTypeId1 = "Some type";
    private final @NonNull String fTypeId2 = "Some other type";
    private final @NonNull String fLabel0 = "label1";
    private final @NonNull String fLabel1 = "label2";
    private final @NonNull String fLabel2 = "label3";
    private final String[] fLabels0 = new String[0];
    private final String[] fLabels1 = new String[]{"label1", "label2"};
    private final String[] fLabels2 = new String[]{"label2", "label1", "label3"};
    private final @NonNull ITmfEventType fType0 = new TmfEventType("Some type", TmfEventField.makeRoot((String[])this.fLabels0));
    private final @NonNull ITmfEventType fType1 = new TmfEventType("Some other type", TmfEventField.makeRoot((String[])this.fLabels1));
    private final @NonNull ITmfEventType fType2 = new TmfEventType("Some type", TmfEventField.makeRoot((String[])this.fLabels2));
    private final @NonNull ITmfEventType fType3 = new TmfEventType("Some other type", TmfEventField.makeRoot((String[])this.fLabels1));

    @Test
    public void testDefaultConstructor() {
        TmfEventType type = new TmfEventType();
        Assert.assertEquals((String)"getName", (Object)"TmfType", (Object)type.getName());
        Assert.assertNull((String)"getRootField", (Object)type.getRootField());
        Assert.assertEquals((String)"getFieldNames", (long)0L, (long)type.getFieldNames().size());
    }

    @Test
    public void testFullConstructor() {
        TmfEventType type0 = new TmfEventType("Some type", TmfEventField.makeRoot((String[])this.fLabels0));
        Assert.assertEquals((String)"getName", (Object)"Some type", (Object)type0.getName());
        Assert.assertEquals((String)"getRootField", (Object)TmfEventField.makeRoot((String[])this.fLabels0), (Object)type0.getRootField());
        Collection labels0 = type0.getFieldNames();
        Assert.assertEquals((String)"getFieldNames length", (long)this.fLabels0.length, (long)labels0.size());
        Assert.assertArrayEquals((Object[])this.fLabels0, (Object[])labels0.toArray(new String[labels0.size()]));
        TmfEventType type1 = new TmfEventType("Some type", TmfEventField.makeRoot((String[])this.fLabels1));
        Assert.assertEquals((String)"getName", (Object)"Some type", (Object)type1.getName());
        Assert.assertEquals((String)"getRootField", (Object)TmfEventField.makeRoot((String[])this.fLabels1), (Object)type1.getRootField());
        Collection labels1 = type1.getFieldNames();
        Assert.assertEquals((String)"getFieldNames length", (long)this.fLabels1.length, (long)labels1.size());
        Assert.assertArrayEquals((Object[])this.fLabels1, (Object[])labels1.toArray(new String[labels1.size()]));
        TmfEventType type2 = new TmfEventType("Some other type", TmfEventField.makeRoot((String[])this.fLabels2));
        Assert.assertEquals((String)"getName", (Object)"Some other type", (Object)type2.getName());
        Assert.assertEquals((String)"getRootField", (Object)TmfEventField.makeRoot((String[])this.fLabels2), (Object)type2.getRootField());
        Collection labels2 = type2.getFieldNames();
        Assert.assertEquals((String)"getFieldNames length", (long)this.fLabels2.length, (long)labels2.size());
        Assert.assertArrayEquals((Object[])this.fLabels2, (Object[])labels2.toArray(new String[labels2.size()]));
    }

    @Test
    public void testCopyConstructor() {
        TmfEventType original = new TmfEventType("Some type", TmfEventField.makeRoot((String[])this.fLabels1));
        TmfEventType copy = new TmfEventType((ITmfEventType)original);
        Assert.assertEquals((String)"getName", (Object)"Some type", (Object)copy.getName());
        Assert.assertEquals((String)"getRootField", (Object)TmfEventField.makeRoot((String[])this.fLabels1), (Object)copy.getRootField());
        Collection labels1 = copy.getFieldNames();
        Assert.assertEquals((String)"getFieldNames length", (long)this.fLabels1.length, (long)labels1.size());
        Assert.assertArrayEquals((Object[])this.fLabels1, (Object[])labels1.toArray(new String[labels1.size()]));
    }

    @Test
    public void testHashCode() {
        TmfEventType copy1 = new TmfEventType(this.fType0);
        Assert.assertTrue((String)"hashCode", (this.fType0.hashCode() == copy1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fType0.hashCode() != this.fType3.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fType0.equals(this.fType0));
        Assert.assertTrue((String)"equals", (boolean)this.fType3.equals(this.fType3));
        Assert.assertFalse((String)"equals", (boolean)this.fType0.equals(this.fType3));
        Assert.assertFalse((String)"equals", (boolean)this.fType3.equals(this.fType0));
    }

    @Test
    public void testEqualsSymmetry() {
        TmfEventType copy0 = new TmfEventType(this.fType0);
        Assert.assertTrue((String)"equals", (boolean)this.fType0.equals(copy0));
        Assert.assertTrue((String)"equals", (boolean)copy0.equals((Object)this.fType0));
        TmfEventType copy1 = new TmfEventType(this.fType1);
        Assert.assertTrue((String)"equals", (boolean)this.fType1.equals(copy1));
        Assert.assertTrue((String)"equals", (boolean)copy1.equals((Object)this.fType1));
        TmfEventType copy2 = new TmfEventType(this.fType2);
        Assert.assertTrue((String)"equals", (boolean)this.fType2.equals(copy2));
        Assert.assertTrue((String)"equals", (boolean)copy2.equals((Object)this.fType2));
    }

    @Test
    public void testEqualsTransivity() {
        TmfEventType copy1 = new TmfEventType(this.fType1);
        TmfEventType copy2 = new TmfEventType((ITmfEventType)copy1);
        Assert.assertTrue((String)"equals", (boolean)this.fType1.equals(copy1));
        Assert.assertTrue((String)"equals", (boolean)copy1.equals((Object)copy2));
        Assert.assertTrue((String)"equals", (boolean)this.fType1.equals(copy2));
        copy1 = new TmfEventType(this.fType2);
        copy2 = new TmfEventType((ITmfEventType)copy1);
        Assert.assertTrue((String)"equals", (boolean)this.fType2.equals(copy1));
        Assert.assertTrue((String)"equals", (boolean)copy1.equals((Object)copy2));
        Assert.assertTrue((String)"equals", (boolean)this.fType2.equals(copy2));
        copy1 = new TmfEventType(this.fType3);
        copy2 = new TmfEventType((ITmfEventType)copy1);
        Assert.assertTrue((String)"equals", (boolean)this.fType3.equals(copy1));
        Assert.assertTrue((String)"equals", (boolean)copy1.equals((Object)copy2));
        Assert.assertTrue((String)"equals", (boolean)this.fType3.equals(copy2));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertFalse((String)"equals", (boolean)this.fType0.equals(null));
        Assert.assertFalse((String)"equals", (boolean)this.fType3.equals(null));
    }

    @Test
    public void testNonEquals() {
        Assert.assertFalse((String)"equals", (boolean)this.fType0.equals(this.fType1));
        Assert.assertFalse((String)"equals", (boolean)this.fType1.equals(this.fType2));
        Assert.assertFalse((String)"equals", (boolean)this.fType2.equals(this.fType3));
        Assert.assertFalse((String)"equals", (boolean)this.fType3.equals(this.fType0));
    }

    @Test
    public void testNonEqualsClasses() {
        Assert.assertFalse((String)"equals", (boolean)this.fType1.equals(this.fLabels1));
    }

    @Test
    public void testToString() {
        String expected1 = "TmfEventType [fTypeId=TmfType]";
        TmfEventType type1 = new TmfEventType();
        Assert.assertEquals((String)"toString", (Object)"TmfEventType [fTypeId=TmfType]", (Object)type1.toString());
        String expected2 = "TmfEventType [fTypeId=Some type]";
        TmfEventType type2 = new TmfEventType("Some type", TmfEventField.makeRoot((String[])this.fLabels1));
        Assert.assertEquals((String)"toString", (Object)"TmfEventType [fTypeId=Some type]", (Object)type2.toString());
    }
}

