/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.stream;

import java.io.IOException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.PcapProtocol;
import org.eclipse.tracecompass.internal.pcap.core.stream.PacketStream;
import org.eclipse.tracecompass.internal.pcap.core.stream.PacketStreamBuilder;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class StreamBuildTest {
    private static final double DELTA = 0.001;

    @Test
    public void StreamBuildingTest() {
        PcapTestTrace trace = PcapTestTrace.MOSTLY_TCP;
        Assume.assumeTrue((boolean)trace.exists());
        try {
            PacketStream stream2;
            PacketStreamBuilder builder = new PacketStreamBuilder(PcapProtocol.ETHERNET_II);
            builder.parsePcapFile(trace.getPath());
            Assert.assertEquals((Object)PcapProtocol.ETHERNET_II, (Object)builder.getProtocol());
            for (PacketStream stream2 : builder.getStreams()) {
                Assert.assertEquals((Object)"Stream eth.0, Number of Packets: 43\n", (Object)stream2.toString());
                Assert.assertEquals((long)43L, (long)stream2.getNbPackets());
                Assert.assertEquals((long)25091L, (long)stream2.getNbBytes());
                Assert.assertEquals((long)20L, (long)stream2.getNbPacketsAtoB());
                Assert.assertEquals((long)2323L, (long)stream2.getNbBytesAtoB());
                Assert.assertEquals((long)23L, (long)stream2.getNbPacketsBtoA());
                Assert.assertEquals((long)22768L, (long)stream2.getNbBytesBtoA());
                Assert.assertEquals((long)1084443427311224000L, (long)stream2.getStartTime());
                Assert.assertEquals((long)1084443457704928000L, (long)stream2.getStopTime());
                Assert.assertEquals((double)30.393704, (double)stream2.getDuration(), (double)0.001);
                Assert.assertEquals((double)76.43030280218561, (double)stream2.getBPSAtoB(), (double)0.001);
                Assert.assertEquals((double)749.1025114938278, (double)stream2.getBPSBtoA(), (double)0.001);
            }
            builder = new PacketStreamBuilder(PcapProtocol.TCP);
            builder.parsePcapFile(trace.getPath());
            Assert.assertEquals((Object)PcapProtocol.TCP, (Object)builder.getProtocol());
            stream2 = builder.getStream(0);
            if (stream2 == null) {
                Assert.fail((String)"StreamBuildingTest has failed!");
                return;
            }
            Assert.assertEquals((Object)PcapProtocol.TCP, (Object)stream2.getProtocol());
            Assert.assertEquals((long)0L, (long)stream2.getID());
            Assert.assertEquals((Object)"tcp.0", (Object)stream2.getUniqueID());
            Assert.assertEquals((long)34L, (long)stream2.getNbPackets());
            Assert.assertEquals((long)20695L, (long)stream2.getNbBytes());
            Assert.assertEquals((long)16L, (long)stream2.getNbPacketsAtoB());
            Assert.assertEquals((long)1351L, (long)stream2.getNbBytesAtoB());
            Assert.assertEquals((long)18L, (long)stream2.getNbPacketsBtoA());
            Assert.assertEquals((long)19344L, (long)stream2.getNbBytesBtoA());
            Assert.assertEquals((long)1084443427311224000L, (long)stream2.getStartTime());
            Assert.assertEquals((long)1084443457704928000L, (long)stream2.getStopTime());
            Assert.assertEquals((double)30.393704, (double)stream2.getDuration(), (double)0.001);
            Assert.assertEquals((double)44.449995301658525, (double)stream2.getBPSAtoB(), (double)0.001);
            Assert.assertEquals((double)636.4476011216008, (double)stream2.getBPSBtoA(), (double)0.001);
            stream2 = builder.getStream(1);
            if (stream2 == null) {
                Assert.fail((String)"StreamBuildingTest has failed!");
                return;
            }
            Assert.assertEquals((Object)PcapProtocol.TCP, (Object)stream2.getProtocol());
            Assert.assertEquals((long)1L, (long)stream2.getID());
            Assert.assertEquals((Object)"tcp.1", (Object)stream2.getUniqueID());
            Assert.assertEquals((long)7L, (long)stream2.getNbPackets());
            Assert.assertEquals((long)4119L, (long)stream2.getNbBytes());
            Assert.assertEquals((long)3L, (long)stream2.getNbPacketsAtoB());
            Assert.assertEquals((long)883L, (long)stream2.getNbBytesAtoB());
            Assert.assertEquals((long)4L, (long)stream2.getNbPacketsBtoA());
            Assert.assertEquals((long)3236L, (long)stream2.getNbBytesBtoA());
            Assert.assertEquals((long)1084443430295515000L, (long)stream2.getStartTime());
            Assert.assertEquals((long)1084443432088092000L, (long)stream2.getStopTime());
            Assert.assertEquals((double)1.792577, (double)stream2.getDuration(), (double)0.001);
            Assert.assertEquals((double)492.58692932019096, (double)stream2.getBPSAtoB(), (double)0.001);
            Assert.assertEquals((double)1805.2223140205413, (double)stream2.getBPSBtoA(), (double)0.001);
            builder.clear();
            Assert.assertEquals((long)0L, (long)builder.getNbStreams());
        }
        catch (IOException | BadPcapFileException e) {
            Assert.fail((String)"StreamBuildingTest has failed!");
        }
    }
}

