/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.file;

import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.util.PcapHelper;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PcapFileOpenFailTest {
    @Test
    public void FileOpenBadPcapTest() throws IOException {
        PcapTestTrace trace = PcapTestTrace.BAD_PCAPFILE;
        Assume.assumeTrue((boolean)trace.exists());
        try {
            PcapHelper.getPcapFile((Path)trace.getPath());
            Assert.fail((String)"The pcapNg was accepted even though the magic number is invalid!");
        }
        catch (IOException | BadPcapFileException e) {
            Assert.assertEquals((Object)"c3d4a1b2 is not a known magic number.", (Object)e.getMessage());
        }
    }

    @Test
    public void FileOpenBinaryFile() throws IOException {
        PcapTestTrace trace = PcapTestTrace.KERNEL_TRACE;
        Assume.assumeTrue((boolean)trace.exists());
        try {
            PcapHelper.getPcapFile((Path)trace.getPath());
            Assert.fail((String)"The file was accepted even though it is not a pcapNg file!");
        }
        catch (IOException | BadPcapFileException e) {
            Assert.assertEquals((Object)"c11ffcc1 is not a known magic number.", (Object)e.getMessage());
        }
    }

    @Test
    public void FileOpenDirectory() throws IOException {
        PcapTestTrace trace = PcapTestTrace.KERNEL_DIRECTORY;
        Assume.assumeTrue((boolean)trace.exists());
        try {
            PcapHelper.getPcapFile((Path)trace.getPath());
            Assert.fail((String)"The file was accepted even though it is not a pcapNg file!");
        }
        catch (IOException | BadPcapFileException e) {
            Assert.assertEquals((Object)"Bad Pcap File.", (Object)e.getMessage());
        }
    }
}

