/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.format;

import java.text.Format;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.format.DecimalUnitFormat;
import org.eclipse.tracecompass.common.core.tests.format.FormatTestBase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DecimalUnitFormatTest
extends FormatTestBase {
    private static final @NonNull Format FORMATTER = new DecimalUnitFormat();

    public DecimalUnitFormatTest(@Nullable Number numValue, @NonNull String stringValue, @Nullable Number parseValue, int parseIndex) {
        super(numValue, stringValue, parseValue, parseIndex);
    }

    @Parameterized.Parameters(name="{index}: {0} - {1}")
    public static Iterable<Object[]> getParameters() {
        Object[][] objectArrayArray = new Object[44][];
        objectArrayArray[0] = new Object[]{3, "3", 3L, -1};
        objectArrayArray[1] = new Object[]{5.6, "5.6", 5.6, -1};
        objectArrayArray[2] = new Object[]{1.234567, "1.2", 1.2, -1};
        objectArrayArray[3] = new Object[]{1.01, "1", 1L, -1};
        objectArrayArray[4] = new Object[]{975, "975", 975L, -1};
        objectArrayArray[5] = new Object[]{1000, "1 k", 1000L, -1};
        objectArrayArray[6] = new Object[]{4000, "4 k", 4000L, -1};
        objectArrayArray[7] = new Object[]{-4000, "-4 k", -4000L, -1};
        objectArrayArray[8] = new Object[]{4000L, "4 k", 4000L, -1};
        objectArrayArray[9] = new Object[]{4000.0, "4 k", 4000L, -1};
        objectArrayArray[10] = new Object[]{12345678, "12.3 M", 12300000L, -1};
        objectArrayArray[11] = new Object[]{Integer.MAX_VALUE, "2.1 G", 2100000000L, -1};
        objectArrayArray[12] = new Object[]{Integer.MIN_VALUE, "-2.1 G", -2100000000L, -1};
        objectArrayArray[13] = new Object[]{Long.MAX_VALUE, "9223.4 P", 9.2234E18, -1};
        objectArrayArray[14] = new Object[]{9.8765432123456E7, "98.8 M", 98800000L, -1};
        objectArrayArray[15] = new Object[]{-9.8765432123456E7, "-98.8 M", -98800000L, -1};
        objectArrayArray[16] = new Object[]{555555555555L, "555.6 G", 555600000000L, -1};
        objectArrayArray[17] = new Object[]{555555555555555L, "555.6 T", 555600000000000L, -1};
        objectArrayArray[18] = new Object[]{100100000, "100.1 M", 100100000L, -1};
        objectArrayArray[19] = new Object[]{0.1, "100 m", 0.1, -1};
        objectArrayArray[20] = new Object[]{0.001, "1 m", 0.001, -1};
        objectArrayArray[21] = new Object[]{1.0E-6, "1 \u00b5", 1.0E-6, -1};
        objectArrayArray[22] = new Object[]{1.0E-9, "1 n", 1.0E-9, -1};
        objectArrayArray[23] = new Object[]{1.0E-12, "1 p", 1.0E-12, -1};
        objectArrayArray[24] = new Object[]{1.0E-13, "0", 0L, -1};
        objectArrayArray[25] = new Object[]{-0.04, "-40 m", -0.04, -1};
        objectArrayArray[26] = new Object[]{0.002, "2 m", 0.002, -1};
        objectArrayArray[27] = new Object[]{0.0555, "55.5 m", 0.0555, -1};
        objectArrayArray[28] = new Object[]{4.928373928E-4, "492.8 \u00b5", 4.928E-4, -1};
        objectArrayArray[29] = new Object[]{2.51E-7, "251 n", 2.51E-7, -1};
        objectArrayArray[30] = new Object[]{4.3E-11, "43 p", 4.3E-11, -1};
        objectArrayArray[31] = new Object[]{4.5643E-8, "45.6 n", 4.56E-8, -1};
        objectArrayArray[32] = new Object[]{Double.MAX_VALUE, "1.7976931348623157E308", Double.MAX_VALUE, -1};
        objectArrayArray[33] = new Object[]{Double.POSITIVE_INFINITY, "\u221e", Double.POSITIVE_INFINITY, -1};
        objectArrayArray[34] = new Object[]{Double.MIN_NORMAL, "0", 0L, -1};
        objectArrayArray[35] = new Object[]{Double.NEGATIVE_INFINITY, "-\u221e", Double.NEGATIVE_INFINITY, -1};
        objectArrayArray[36] = new Object[]{Double.NaN, "\ufffd", Double.NaN, -1};
        Object[] objectArray = new Object[4];
        objectArray[1] = "Toto";
        objectArray[3] = -1;
        objectArrayArray[37] = objectArray;
        Object[] objectArray2 = new Object[4];
        objectArray2[1] = "1.2 s";
        objectArray2[2] = 1.2;
        objectArray2[3] = 3;
        objectArrayArray[38] = objectArray2;
        Object[] objectArray3 = new Object[4];
        objectArray3[1] = "1.2 ms";
        objectArray3[2] = 0.0012;
        objectArray3[3] = 5;
        objectArrayArray[39] = objectArray3;
        Object[] objectArray4 = new Object[4];
        objectArray4[1] = "\u221e k";
        objectArray4[2] = Double.POSITIVE_INFINITY;
        objectArray4[3] = -1;
        objectArrayArray[40] = objectArray4;
        Object[] objectArray5 = new Object[4];
        objectArray5[1] = "-\u221e p";
        objectArray5[2] = Double.NEGATIVE_INFINITY;
        objectArray5[3] = -1;
        objectArrayArray[41] = objectArray5;
        Object[] objectArray6 = new Object[4];
        objectArray6[1] = "\ufffdM";
        objectArray6[2] = Double.NaN;
        objectArray6[3] = -1;
        objectArrayArray[42] = objectArray6;
        Object[] objectArray7 = new Object[4];
        objectArray7[1] = "1.2 m  ";
        objectArray7[2] = 0.0012;
        objectArray7[3] = 5;
        objectArrayArray[43] = objectArray7;
        return Arrays.asList(objectArrayArray);
    }

    @Override
    protected Format getFormatter() {
        return FORMATTER;
    }

    @Override
    @Test(expected=IllegalArgumentException.class)
    public void testFormatIllegalArgument() {
        FORMATTER.format("Toto");
    }
}

