/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.registry.TeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.ITeamContentProviderManager;

public class TeamContentProviderManager
implements ITeamContentProviderManager {
    public static final String PT_TEAM_CONTENT_PROVIDERS = "teamContentProviders";
    private static ITeamContentProviderManager instance;
    Map<String, ITeamContentProviderDescriptor> descriptors;
    private ListenerList<IPropertyChangeListener> listeners = new ListenerList(1);

    public static ITeamContentProviderManager getInstance() {
        if (instance == null) {
            instance = new TeamContentProviderManager();
        }
        return instance;
    }

    @Override
    public ITeamContentProviderDescriptor[] getDescriptors() {
        this.lazyInitialize();
        return this.descriptors.values().toArray(new ITeamContentProviderDescriptor[this.descriptors.size()]);
    }

    @Override
    public String[] getContentProviderIds(ISynchronizationScope scope) {
        ITeamContentProviderDescriptor[] descriptors;
        ArrayList<String> result = new ArrayList<String>();
        ITeamContentProviderDescriptor[] iTeamContentProviderDescriptorArray = descriptors = this.getDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamContentProviderDescriptor descriptor = iTeamContentProviderDescriptorArray[n2];
            if (descriptor.isEnabled() && scope.getMappings(descriptor.getModelProviderId()).length > 0) {
                result.add(descriptor.getContentExtensionId());
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public ITeamContentProviderDescriptor getDescriptor(String modelProviderId) {
        this.lazyInitialize();
        return this.descriptors.get(modelProviderId);
    }

    protected void lazyInitialize() {
        if (this.descriptors != null) {
            return;
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.ui", PT_TEAM_CONTENT_PROVIDERS);
        IExtension[] extensions = point.getExtensions();
        this.descriptors = new HashMap<String, ITeamContentProviderDescriptor>(extensions.length * 2);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            TeamContentProviderDescriptor desc = null;
            try {
                desc = new TeamContentProviderDescriptor(extension);
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
            if (desc != null) {
                this.descriptors.put(desc.getModelProviderId(), desc);
            }
            ++n2;
        }
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void firePropertyChange(final PropertyChangeEvent event) {
        Object[] allListeners;
        Object[] objectArray = allListeners = this.listeners.getListeners();
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            final IPropertyChangeListener listener = (IPropertyChangeListener)l;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.propertyChange(event);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++n2;
        }
    }

    public void enablementChanged(ITeamContentProviderDescriptor[] oldEnabled, ITeamContentProviderDescriptor[] newEnabled) {
        this.firePropertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.team.ui.ENABLED_MODEL_PROVIDERS", (Object)oldEnabled, (Object)newEnabled));
    }

    @Override
    public void setEnabledDescriptors(ITeamContentProviderDescriptor[] descriptors) {
        ArrayList<TeamContentProviderDescriptor> previouslyEnabled = new ArrayList<TeamContentProviderDescriptor>();
        for (ITeamContentProviderDescriptor element : this.descriptors.values()) {
            TeamContentProviderDescriptor descriptor = (TeamContentProviderDescriptor)element;
            if (!descriptor.isEnabled()) continue;
            previouslyEnabled.add(descriptor);
            descriptor.setEnabled(false);
        }
        ITeamContentProviderDescriptor[] iTeamContentProviderDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamContentProviderDescriptor d = iTeamContentProviderDescriptorArray[n2];
            TeamContentProviderDescriptor descriptor = (TeamContentProviderDescriptor)d;
            descriptor.setEnabled(true);
            ++n2;
        }
        this.enablementChanged(previouslyEnabled.toArray(new ITeamContentProviderDescriptor[previouslyEnabled.size()]), descriptors);
    }
}

