/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.DocValuesWriter;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.SortingLeafReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.packed.PackedLongValues;

class NumericDocValuesWriter
extends DocValuesWriter {
    private PackedLongValues.Builder pending = PackedLongValues.deltaPackedBuilder(0.0f);
    private PackedLongValues finalValues;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private DocsWithFieldSet docsWithField = new DocsWithFieldSet();
    private final FieldInfo fieldInfo;
    private int lastDocID = -1;

    public NumericDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, long value) {
        if (docID <= this.lastDocID) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        this.pending.add(value);
        this.docsWithField.add(docID);
        this.updateBytesUsed();
        this.lastDocID = docID;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    public void finish(int maxDoc) {
    }

    @Override
    Sorter.DocComparator getDocComparator(int maxDoc, SortField sortField) throws IOException {
        assert (this.finalValues == null);
        this.finalValues = this.pending.build();
        BufferedNumericDocValues docValues = new BufferedNumericDocValues(this.finalValues, this.docsWithField.iterator());
        return Sorter.getDocComparator(maxDoc, sortField, () -> null, () -> docValues);
    }

    @Override
    DocIdSetIterator getDocIdSet() {
        return this.docsWithField.iterator();
    }

    static SortingLeafReader.CachedNumericDVs sortDocValues(int maxDoc, Sorter.DocMap sortMap, NumericDocValues oldDocValues) throws IOException {
        int docID;
        FixedBitSet docsWithField = new FixedBitSet(maxDoc);
        long[] values = new long[maxDoc];
        while ((docID = oldDocValues.nextDoc()) != Integer.MAX_VALUE) {
            int newDocID = sortMap.oldToNew(docID);
            docsWithField.set(newDocID);
            values[newDocID] = oldDocValues.longValue();
        }
        return new SortingLeafReader.CachedNumericDVs(values, docsWithField);
    }

    @Override
    public void flush(SegmentWriteState state, Sorter.DocMap sortMap, DocValuesConsumer dvConsumer) throws IOException {
        SortingLeafReader.CachedNumericDVs sorted;
        final PackedLongValues values = this.finalValues == null ? this.pending.build() : this.finalValues;
        if (sortMap != null) {
            BufferedNumericDocValues oldValues = new BufferedNumericDocValues(values, this.docsWithField.iterator());
            sorted = NumericDocValuesWriter.sortDocValues(state.segmentInfo.maxDoc(), sortMap, oldValues);
        } else {
            sorted = null;
        }
        dvConsumer.addNumericField(this.fieldInfo, new EmptyDocValuesProducer(){

            @Override
            public NumericDocValues getNumeric(FieldInfo fieldInfo) {
                if (fieldInfo != NumericDocValuesWriter.this.fieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                if (sorted == null) {
                    return new BufferedNumericDocValues(values, NumericDocValuesWriter.this.docsWithField.iterator());
                }
                return new SortingLeafReader.SortingNumericDocValues(sorted);
            }
        });
    }

    private static class BufferedNumericDocValues
    extends NumericDocValues {
        final PackedLongValues.Iterator iter;
        final DocIdSetIterator docsWithField;
        private long value;

        BufferedNumericDocValues(PackedLongValues values, DocIdSetIterator docsWithFields) {
            this.iter = values.iterator();
            this.docsWithField = docsWithFields;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.value = this.iter.next();
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        @Override
        public long longValue() {
            return this.value;
        }
    }
}

