/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.util;

import com.google.common.base.Joiner;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.colors.ColorUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEventStyleStrings;

public final class TimeGraphStyleUtil {
    private static final char SEPARATOR = '.';
    private static final String PREFIX = "view.";

    private TimeGraphStyleUtil() {
    }

    public static void loadValue(ITimeGraphPresentationProvider presentationProvider, StateItem stateItem) {
        IPreferenceStore store = TimeGraphStyleUtil.getStore();
        String oldFillColorKey = TimeGraphStyleUtil.getPreferenceName(presentationProvider, stateItem, ITimeEventStyleStrings.fillColor());
        String oldHeightFactorKey = TimeGraphStyleUtil.getPreferenceName(presentationProvider, stateItem, ITimeEventStyleStrings.heightFactor());
        String fillColorKey = TimeGraphStyleUtil.getPreferenceName(presentationProvider, stateItem, "background-color");
        String heightFactorKey = TimeGraphStyleUtil.getPreferenceName(presentationProvider, stateItem, "height");
        Map<String, Object> styleMap = stateItem.getStyleMap();
        String prefRgbColor = store.getString(fillColorKey);
        if (!prefRgbColor.isEmpty()) {
            styleMap.put("background-color", prefRgbColor);
            styleMap.put("color", prefRgbColor);
        } else {
            RGBAColor prefRgba;
            String oldPrefRgbColor = store.getString(oldFillColorKey);
            if (!oldPrefRgbColor.isEmpty() && (prefRgba = RGBAColor.fromString((String)oldPrefRgbColor)) != null) {
                String hexColor = ColorUtils.toHexColor(prefRgba.getRed(), prefRgba.getGreen(), prefRgba.getBlue());
                styleMap.put("background-color", hexColor);
                styleMap.put("color", hexColor);
                store.setValue(fillColorKey, hexColor);
            }
        }
        store.setDefault(heightFactorKey, -1.0f);
        store.setDefault(oldHeightFactorKey, -1.0f);
        float prefHeightFactor = store.getFloat(heightFactorKey);
        if (prefHeightFactor != -1.0f) {
            styleMap.put("height", Float.valueOf(prefHeightFactor));
        } else {
            prefHeightFactor = store.getFloat(oldHeightFactorKey);
            if (prefHeightFactor != -1.0f) {
                styleMap.put("height", Float.valueOf(prefHeightFactor));
                store.setValue(heightFactorKey, prefHeightFactor);
            }
        }
    }

    private static @Nullable Object getItemProperty(StateItem stateItem) {
        return stateItem.getStyleMap().get(ITimeEventStyleStrings.itemTypeProperty());
    }

    public static String getPreferenceName(ITimeGraphPresentationProvider presentationProvider, StateItem stateItem, String styleKey) {
        return Joiner.on((char)'.').skipNulls().join((Object)(PREFIX + String.valueOf(presentationProvider.getPreferenceKey())), TimeGraphStyleUtil.getItemProperty(stateItem), new Object[]{stateItem.getStateString(), styleKey});
    }

    public static void loadValues(ITimeGraphPresentationProvider presentationProvider) {
        StateItem[] stateItemArray = presentationProvider.getStateTable();
        int n = stateItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            StateItem stateItem = stateItemArray[n2];
            TimeGraphStyleUtil.loadValue(presentationProvider, stateItem);
            ++n2;
        }
    }

    public static IPreferenceStore getStore() {
        return Activator.getDefault().getPreferenceStore();
    }
}

