/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.model;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;

public class HostThread {
    public static final String SELECTED_HOST_THREAD_KEY = "model.selectedThread";
    private static final HashFunction HF = (HashFunction)NonNullUtils.checkNotNull((Object)Hashing.goodFastHash((int)32));
    private final String fHost;
    private final Integer fTid;

    public HostThread(String host, Integer tid) {
        this.fHost = host;
        this.fTid = tid;
    }

    public int hashCode() {
        return HF.newHasher().putUnencodedChars((CharSequence)this.fHost).putInt(this.fTid.intValue()).hash().asInt();
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof HostThread) {
            HostThread hostTid = (HostThread)o;
            if (this.fTid.equals(hostTid.fTid) && this.fHost.equals(hostTid.fHost)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "HostTid: [" + this.fHost + "," + String.valueOf(this.fTid) + "]";
    }

    public Integer getTid() {
        return this.fTid;
    }

    public String getHost() {
        return this.fHost;
    }
}

