/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.analysis.kernel;

import java.io.File;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.analysis.kernel.KernelAnalysisModuleNullBeStub;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class KernelAnalysisBenchmark {
    public static final String TEST_ID = "org.eclipse.linuxtools#LTTng kernel analysis#";
    private static final int LOOP_COUNT = 25;
    private final TestModule fTestModule;

    public KernelAnalysisBenchmark(String testName, TestModule module) {
        this.fTestModule = module;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({TestModule.NORMAL_EXECUTION.name(), TestModule.NORMAL_EXECUTION}, {TestModule.NULL_BACKEND.name(), TestModule.NULL_BACKEND});
    }

    @Test
    public void testTrace2() {
        KernelAnalysisBenchmark.runTest(CtfTestTrace.TRACE2, "Trace2", this.fTestModule);
    }

    @Test
    public void testManyThreads() {
        KernelAnalysisBenchmark.runTest(CtfTestTrace.MANY_THREADS, "Many Threads", this.fTestModule);
    }

    @Test
    public void testDjangoHttpd() {
        KernelAnalysisBenchmark.runTest(CtfTestTrace.DJANGO_HTTPD, "Django httpd", this.fTestModule);
    }

    private static void runTest(@NonNull CtfTestTrace testTrace, String testName, TestModule testModule) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + testName + testModule.getTestNameString());
        perf.tagAsSummary(pm, "LTTng Kernel Analysis: " + testName + testModule.getTestNameString(), Dimension.CPU_TIME);
        if (testTrace == CtfTestTrace.TRACE2 && testModule == TestModule.NORMAL_EXECUTION) {
            perf.tagAsGlobalSummary(pm, "LTTng Kernel Analysis" + testModule.getTestNameString() + ": " + testName, Dimension.CPU_TIME);
        }
        int i = 0;
        while (i < 25) {
            block14: {
                LttngKernelTrace trace = null;
                IAnalysisModule module = null;
                String path = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)testTrace).getPath();
                try {
                    try {
                        trace = new LttngKernelTrace();
                        module = TestModule.getNewModule(testModule);
                        module.setId("test");
                        trace.initTrace(null, path, CtfTmfEvent.class);
                        module.setTrace((ITmfTrace)trace);
                        pm.start();
                        TmfTestHelper.executeAnalysis((IAnalysisModule)module);
                        pm.stop();
                        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
                        File[] fileArray = suppDir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            file.delete();
                            ++n2;
                        }
                    }
                    catch (TmfAnalysisException | TmfTraceException e) {
                        Assert.fail((String)e.getMessage());
                        if (module != null) {
                            module.dispose();
                        }
                        if (trace != null) {
                            trace.dispose();
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (module != null) {
                        module.dispose();
                    }
                    if (trace != null) {
                        trace.dispose();
                    }
                    throw throwable;
                }
                if (module != null) {
                    module.dispose();
                }
                if (trace != null) {
                    trace.dispose();
                }
            }
            ++i;
        }
        pm.commit();
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)testTrace);
    }

    private static enum TestModule {
        NORMAL_EXECUTION(""),
        NULL_BACKEND("(Data not saved to disk)");

        private final String fName;

        private TestModule(String name) {
            this.fName = name;
        }

        public String getTestNameString() {
            return this.fName;
        }

        public static IAnalysisModule getNewModule(TestModule moduleType) {
            switch (moduleType) {
                case NORMAL_EXECUTION: {
                    return new KernelAnalysisModule();
                }
                case NULL_BACKEND: {
                    return new KernelAnalysisModuleNullBeStub();
                }
            }
            throw new IllegalStateException();
        }
    }
}

