/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.chart.core.tests.chart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartData;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartSeries;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDataChartDescriptor;
import org.eclipse.tracecompass.tmf.chart.core.model.IDataChartProvider;
import org.eclipse.tracecompass.tmf.chart.core.tests.stubs.StubChartProvider;
import org.eclipse.tracecompass.tmf.chart.core.tests.stubs.StubObject;
import org.junit.Assert;
import org.junit.Test;

public class ChartDataTest {
    private final @NonNull StubChartProvider fProvider = new StubChartProvider();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testGetDescriptors() {
        Collection<@NonNull IDataChartDescriptor<StubObject, ?>> dataDescriptors = this.fProvider.getDataDescriptors();
        IDataChartDescriptor<StubObject, ?> xDesc = null;
        for (IDataChartDescriptor<StubObject, ?> desc : dataDescriptors) {
            if (!desc.getName().equals("String")) continue;
            xDesc = desc;
            break;
        }
        Assert.assertNotNull(xDesc);
        ArrayList<@NonNull ChartSeries> list = new ArrayList<ChartSeries>();
        for (IDataChartDescriptor<StubObject, ?> desc : dataDescriptors) {
            if (desc.getName().equals("String")) continue;
            list.add(new ChartSeries(xDesc, desc));
        }
        Assert.assertEquals((long)3L, (long)list.size());
        ChartData data = new ChartData((IDataChartProvider)this.fProvider, list);
        @NonNull Collection chartSeries = data.getChartSeries();
        Assert.assertEquals((long)3L, (long)chartSeries.size());
        Assert.assertEquals(xDesc, (Object)data.getX(0));
        Assert.assertEquals(xDesc, (Object)data.getX(1));
        Assert.assertEquals(xDesc, (Object)data.getX(2));
        Assert.assertEquals((Object)((ChartSeries)list.get(0)).getY(), (Object)data.getY(0));
        Assert.assertEquals((Object)((ChartSeries)list.get(1)).getY(), (Object)data.getY(1));
        Assert.assertEquals((Object)((ChartSeries)list.get(2)).getY(), (Object)data.getY(2));
    }

    @Test
    public void testImmutableSeries() {
        Iterator<@NonNull IDataChartDescriptor<StubObject, ?>> dataDescriptors = this.fProvider.getDataDescriptors().iterator();
        IDataChartDescriptor<StubObject, ?> x = dataDescriptors.next();
        IDataChartDescriptor<StubObject, ?> y = dataDescriptors.next();
        ArrayList<@NonNull ChartSeries> list = new ArrayList<ChartSeries>();
        list.add(new ChartSeries(x, y));
        ChartData data = new ChartData((IDataChartProvider)this.fProvider, list);
        Assert.assertEquals((long)1L, (long)data.getChartSeries().size());
        y = dataDescriptors.next();
        list.add(new ChartSeries(x, y));
        Assert.assertEquals((long)1L, (long)data.getChartSeries().size());
    }
}

