/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.event;

import com.google.common.primitives.Longs;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.ITmfLostEvent;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

@NonNullByDefault
public class CtfTmfLostEvent
extends CtfTmfEvent
implements ITmfLostEvent {
    private final TmfTimeRange fTimeRange;
    private final long fNbLost;

    CtfTmfLostEvent(CtfTmfTrace trace, long rank, String fileName, int cpu, IEventDeclaration declaration, TmfTimeRange timeRange, long nbLost, IEventDefinition def) {
        super(trace, rank, timeRange.getStartTime(), fileName, cpu, declaration, def);
        this.fTimeRange = timeRange;
        this.fNbLost = nbLost;
    }

    public TmfTimeRange getTimeRange() {
        return this.fTimeRange;
    }

    public long getNbLostEvents() {
        return this.fNbLost;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getTimeRange().hashCode();
        result = 31 * result + Longs.hashCode((long)this.getNbLostEvents());
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CtfTmfLostEvent other = (CtfTmfLostEvent)((Object)NonNullUtils.checkNotNull((Object)((Object)((CtfTmfLostEvent)((Object)obj)))));
        if (!this.getTimeRange().equals((Object)other.getTimeRange())) {
            return false;
        }
        return this.getNbLostEvents() == other.getNbLostEvents();
    }
}

