/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.SimpleDatatypeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDefinition;

public class VariantDeclaration
extends Declaration {
    private String fTag = null;
    private static final long ALIGNMENT = 1L;
    private final Map<String, IDeclaration> fFields = new HashMap<String, IDeclaration>();
    private IDeclaration[] fFieldArray = new IDeclaration[0];
    private IDeclaration fDeclarationToPopulate;

    public boolean isTagged() {
        return this.fTag != null;
    }

    public boolean hasField(String fieldTag) {
        return this.fFields.containsKey(fieldTag);
    }

    public void setTag(String tag) {
        this.fTag = tag;
    }

    public String getTag() {
        return this.fTag;
    }

    public Map<String, IDeclaration> getFields() {
        return this.fFields;
    }

    @Override
    public long getAlignment() {
        return 1L;
    }

    @Override
    public VariantDefinition createDefinition(IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        this.alignRead(input);
        IDefinition def = definitionScope.lookupDefinition(this.fTag);
        String varFieldName = this.fTag;
        SimpleDatatypeDefinition tagDef = null;
        if (def instanceof IntegerDefinition) {
            tagDef = (SimpleDatatypeDefinition)def;
            Long tagValue = ((IntegerDefinition)tagDef).getIntegerValue();
            String mappings = ((IntegerDefinition)tagDef).getMappings();
            if (mappings != null && !mappings.isBlank()) {
                this.fDeclarationToPopulate = this.fFields.get(mappings);
            } else if (tagValue != null) {
                if (tagValue < 0L || tagValue >= (long)this.fFieldArray.length) {
                    throw new CTFException("Unknown value of " + String.valueOf(tagValue) + " for the variant " + this.toString());
                }
                this.fDeclarationToPopulate = this.fFieldArray[tagValue.intValue()];
            }
        } else {
            tagDef = (EnumDefinition)(def instanceof EnumDefinition ? def : null);
            if (tagDef == null) {
                throw new CTFException("Tag is not defined " + this.fTag);
            }
            varFieldName = tagDef.getStringValue();
            if (varFieldName == null) {
                throw new CTFException("Undefined enum selector for variant " + definitionScope.getScopePath().getPath());
            }
            this.fDeclarationToPopulate = this.fFields.get(varFieldName);
        }
        if (this.fDeclarationToPopulate == null) {
            throw new CTFException("Unknown enum selector for variant " + definitionScope.getScopePath().getPath());
        }
        Definition fieldValue = this.fDeclarationToPopulate.createDefinition(definitionScope, fieldName, input);
        return new VariantDefinition(this, definitionScope, tagDef, varFieldName, fieldName, fieldValue);
    }

    public void addField(String fieldTag, IDeclaration declaration) {
        IDeclaration prevDeclaration = this.fFields.get(fieldTag);
        if (prevDeclaration != null) {
            boolean found = false;
            int i = 0;
            while (i < this.fFieldArray.length) {
                IDeclaration field = this.fFieldArray[i];
                if (field == prevDeclaration) {
                    this.fFieldArray[i] = declaration;
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                throw new IllegalStateException("Field tags inconsitent: " + fieldTag + " fields: " + String.valueOf(this.fFields));
            }
        } else {
            int size = this.fFields.size() + 1;
            this.fFieldArray = Arrays.copyOf(this.fFieldArray, size);
            this.fFieldArray[size - 1] = declaration;
        }
        this.fFields.put(fieldTag, declaration);
    }

    @Override
    public int getMaximumSize() {
        Collection<IDeclaration> values = this.fFields.values();
        int maxSize = 0;
        for (IDeclaration field : values) {
            maxSize = Math.max(maxSize, field.getMaximumSize());
        }
        return maxSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[declaration] variant[");
        for (Map.Entry<String, IDeclaration> field : this.fFields.entrySet()) {
            sb.append(field.getKey()).append(':').append(field.getValue());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fDeclarationToPopulate == null ? 0 : this.fDeclarationToPopulate.hashCode());
        if (this.fFields == null) {
            result *= 31;
        } else {
            for (Map.Entry<String, IDeclaration> field : this.fFields.entrySet()) {
                result = 31 * result + field.getValue().hashCode();
            }
        }
        result = 31 * result + (this.fTag == null ? 0 : this.fTag.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariantDeclaration other = (VariantDeclaration)obj;
        if (!Objects.equals(this.fDeclarationToPopulate, other.fDeclarationToPopulate)) {
            return false;
        }
        if (!Objects.equals(this.fFields, other.fFields)) {
            return false;
        }
        return Objects.equals(this.fTag, other.fTag);
    }

    @Override
    public boolean isBinaryEquivalent(IDeclaration obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariantDeclaration other = (VariantDeclaration)obj;
        if (this.fFields == null) {
            if (other.fFields != null) {
                return false;
            }
        } else {
            if (this.fFields.size() != other.fFields.size()) {
                return false;
            }
            for (Map.Entry<String, IDeclaration> field : this.fFields.entrySet()) {
                if (!other.fFields.containsKey(field.getKey())) {
                    return false;
                }
                IDeclaration field2 = other.fFields.get(field.getKey());
                if (field2 != null && field2.isBinaryEquivalent(field.getValue())) continue;
                return false;
            }
        }
        return true;
    }
}

