/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xychart;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfAbstractToolTipHandler;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IAxis;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IXYSeries;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfBaseProvider;

public class TmfClosestDataPointTooltipProvider
extends TmfBaseProvider
implements MouseMoveListener,
PaintListener {
    private static final @NonNull String OLD_TOOLTIP = "";
    private static final int ALPHA = 128;
    private static final int HIGHLIGHT_RADIUS = 5;
    private int fHighlightX;
    private int fHighlightY;
    private boolean fIsHighlight;
    private TmfAbstractToolTipHandler fTooltipHandler = new XYToolTipHandler();

    public TmfClosestDataPointTooltipProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
        this.register();
    }

    @Override
    public void refresh() {
    }

    @Override
    public TmfAbstractToolTipHandler getTooltipHandler() {
        return this.fTooltipHandler;
    }

    public void mouseMove(@Nullable MouseEvent e) {
        if (this.fIsHighlight) {
            this.fIsHighlight = false;
            this.redraw();
        }
    }

    public void paintControl(PaintEvent e) {
        if (this.fIsHighlight && e != null) {
            e.gc.setBackground(Display.getDefault().getSystemColor(3));
            e.gc.setAlpha(128);
            e.gc.fillOval(this.fHighlightX - 5, this.fHighlightY - 5, 10, 10);
        }
    }

    protected @Nullable Map<@NonNull String, @NonNull Map<@NonNull String, @NonNull Object>> createToolTipMap(@NonNull Parameter param) {
        List<IXYSeries> series = this.getSeries();
        int seriesIndex = param.getSeriesIndex();
        int dataIndex = param.getDataIndex();
        if (series != null && seriesIndex < series.size()) {
            IXYSeries serie = series.get(seriesIndex);
            double[] xS = serie.getXSeries();
            double[] yS = serie.getYSeries();
            if (xS != null && yS != null && dataIndex < xS.length && dataIndex < yS.length) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("x=");
                buffer.append(TmfTimestamp.fromNanos((long)((long)xS[dataIndex] + this.getChartViewer().getTimeOffset())).toString());
                buffer.append('\n');
                buffer.append("y=");
                buffer.append((long)yS[dataIndex]);
                return Collections.singletonMap(OLD_TOOLTIP, Collections.singletonMap(OLD_TOOLTIP, buffer.toString()));
            }
        }
        return null;
    }

    protected static class Parameter {
        private int seriesIndex;
        private int dataIndex;

        protected Parameter() {
        }

        public int getSeriesIndex() {
            return this.seriesIndex;
        }

        public void setSeriesIndex(int seriesIndex) {
            this.seriesIndex = seriesIndex;
        }

        public int getDataIndex() {
            return this.dataIndex;
        }

        public void setDataIndex(int dataIndex) {
            this.dataIndex = dataIndex;
        }
    }

    private final class XYToolTipHandler
    extends TmfAbstractToolTipHandler {
        private XYToolTipHandler() {
        }

        @Override
        public void fill(Control control, MouseEvent e, Point pt) {
            if (TmfClosestDataPointTooltipProvider.this.getChartViewer().getWindowDuration() != 0L && e != null) {
                IAxis xAxis = TmfClosestDataPointTooltipProvider.this.getXAxis();
                IAxis yAxis = TmfClosestDataPointTooltipProvider.this.getYAxis();
                List<IXYSeries> series = TmfClosestDataPointTooltipProvider.this.getSeries();
                double smallestDistance = Double.MAX_VALUE;
                Parameter param = null;
                int k = 0;
                while (k < series.size()) {
                    IXYSeries serie = series.get(k);
                    double[] xS = serie.getXSeries();
                    double[] yS = serie.getYSeries();
                    if (xS != null && yS != null) {
                        int i = 0;
                        while (i < xS.length) {
                            int ys;
                            int xs = xAxis.getPixelCoordinate(xS[i]) - e.x;
                            double currentDistance = xs * xs + (ys = yAxis.getPixelCoordinate(yS[i]) - e.y) * ys;
                            if (currentDistance < smallestDistance && currentDistance < 25.0) {
                                smallestDistance = currentDistance;
                                TmfClosestDataPointTooltipProvider.this.fHighlightX = xs + e.x;
                                TmfClosestDataPointTooltipProvider.this.fHighlightY = ys + e.y;
                                if (param == null) {
                                    param = new Parameter();
                                }
                                param.setSeriesIndex(k);
                                param.setDataIndex(i);
                            }
                            ++i;
                        }
                    }
                    ++k;
                }
                Map<String, Map<String, Object>> tooltip = null;
                if (param != null) {
                    tooltip = TmfClosestDataPointTooltipProvider.this.createToolTipMap(param);
                    if (tooltip == null) {
                        return;
                    }
                    TmfClosestDataPointTooltipProvider.this.fIsHighlight = true;
                    TmfClosestDataPointTooltipProvider.this.redraw();
                }
                if (tooltip == null) {
                    return;
                }
                for (Map.Entry entry : tooltip.entrySet()) {
                    TmfAbstractToolTipHandler.ToolTipString category = ((String)entry.getKey()).isEmpty() || ((String)entry.getKey()).equals(TmfClosestDataPointTooltipProvider.OLD_TOOLTIP) ? null : TmfAbstractToolTipHandler.ToolTipString.fromString((String)entry.getKey());
                    for (Map.Entry secondEntry : ((Map)entry.getValue()).entrySet()) {
                        Object value = secondEntry.getValue();
                        String key = (String)secondEntry.getKey();
                        if (value instanceof Number) {
                            this.addItem(category, TmfAbstractToolTipHandler.ToolTipString.fromString(key), TmfAbstractToolTipHandler.ToolTipString.fromDecimal((Number)value));
                            continue;
                        }
                        if (value instanceof ITmfTimestamp) {
                            this.addItem(category, TmfAbstractToolTipHandler.ToolTipString.fromString(key), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(String.valueOf(value), ((ITmfTimestamp)value).toNanos()));
                            continue;
                        }
                        this.addItem(category, TmfAbstractToolTipHandler.ToolTipString.fromString(key), TmfAbstractToolTipHandler.ToolTipString.fromString(String.valueOf(value)));
                    }
                }
            }
        }
    }
}

