/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;

public class ClasspathJMod
extends ClasspathJar {
    public static char[] CLASSES = "classes".toCharArray();
    public static final String CLASSES_FOLDER = "classes/";

    ClasspathJMod(String zipFilename, long lastModified, AccessRuleSet accessRuleSet, IPath externalAnnotationPath) {
        super(zipFilename, lastModified, accessRuleSet, externalAnnotationPath, true);
    }

    @Override
    IModule initializeModule() {
        IBinaryModule mod = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile file = new ZipFile(this.zipFilename);){
                String fileName = "classes/module-info.class";
                ClassFileReader classfile = ClassFileReader.read((ZipFile)file, (String)fileName);
                if (classfile != null) {
                    mod = classfile.getModuleDeclaration();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassFormatException throwable) {
            // empty catch block
        }
        return mod;
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        if (!this.isPackage(qualifiedPackageName, moduleName)) {
            return null;
        }
        if (moduleNameFilter != null && this.module != null && !moduleNameFilter.test(String.valueOf(this.module.name()))) {
            return null;
        }
        try {
            qualifiedBinaryFileName = CLASSES_FOLDER + (String)qualifiedBinaryFileName;
            ClassFileReader reader = ClassFileReader.read((ZipFile)this.zipFile, (String)qualifiedBinaryFileName);
            if (reader != null) {
                char[] modName;
                char[] cArray = modName = this.module == null ? null : this.module.name();
                if (reader instanceof ClassFileReader) {
                    ClassFileReader classReader = reader;
                    if (classReader.moduleName == null) {
                        classReader.moduleName = modName;
                    } else {
                        modName = classReader.moduleName;
                    }
                }
                String fileNameWithoutExtension = ((String)qualifiedBinaryFileName).substring(0, ((String)qualifiedBinaryFileName).length() - SuffixConstants.SUFFIX_CLASS.length);
                return this.createAnswer(fileNameWithoutExtension, (IBinaryType)reader, modName);
            }
        }
        catch (IOException | ClassFormatException throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected Set<String> readPackageNames() {
        HashSet<String> packageSet = new HashSet<String>();
        packageSet.add("");
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            char[] folder;
            ZipEntry entry = e.nextElement();
            char[] entryName = entry.getName().toCharArray();
            int index = CharOperation.indexOf((char)'/', (char[])entryName);
            if (index == -1 || !CharOperation.equals((char[])CLASSES, (char[])(folder = CharOperation.subarray((char[])entryName, (int)0, (int)index)))) continue;
            char[] fileName = CharOperation.subarray((char[])entryName, (int)(index + 1), (int)entryName.length);
            ClasspathJMod.addToPackageSet(packageSet, new String(fileName), false);
        }
        return packageSet;
    }
}

