/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.dialogs.DetailsDialog;

public class DetailsDialogWithProjects
extends DetailsDialog {
    private final String message;
    private final String detailsTitle;
    private final IProject[] projects;
    private List detailsList;
    private final boolean includeCancelButton;

    public DetailsDialogWithProjects(Shell parentShell, String dialogTitle, String dialogMessage, String detailsTitle, IProject[] projects, boolean includeCancelButton, String imageKey) {
        super(parentShell, dialogTitle);
        this.setImageKey(imageKey);
        this.message = dialogMessage;
        this.detailsTitle = detailsTitle;
        this.projects = projects;
        this.includeCancelButton = includeCancelButton;
    }

    @Override
    protected void createMainDialogArea(Composite composite) {
        Label label = new Label(composite, 64);
        label.setText(this.message);
        GridData data = new GridData(4, 0x1000004, true, false);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        this.updateEnablements();
    }

    @Override
    protected Composite createDropDownDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        if (this.detailsTitle != null) {
            Label title = new Label(composite, 64);
            title.setText(this.detailsTitle);
            title.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        this.detailsList = new List(composite, 2818);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = this.convertHeightInCharsToPixels(5);
        this.detailsList.setLayoutData((Object)data);
        IProject[] iProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.detailsList.add(project.getName());
            ++n2;
        }
        return composite;
    }

    @Override
    protected void updateEnablements() {
        this.setPageComplete(true);
    }

    @Override
    protected boolean includeCancelButton() {
        return this.includeCancelButton;
    }

    @Override
    protected boolean isMainGrabVertical() {
        return false;
    }
}

