/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;

public class SeriesModelSerializer
extends StdSerializer<ISeriesModel> {
    private static final long serialVersionUID = -4359431726167157401L;

    public SeriesModelSerializer() {
        super(ISeriesModel.class);
    }

    public void serialize(ISeriesModel value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeNumberField("seriesId", value.getId());
        gen.writeStringField("seriesName", value.getName());
        gen.writeObjectField("xValues", (Object)value.getSampling());
        gen.writeObjectField("yValues", (Object)value.getData());
        String type = value.getDisplayType().name().toLowerCase().trim();
        OutputElementStyle style = new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"series-type", (Object)type));
        gen.writeObjectField("style", (Object)style);
        gen.writeObjectField("xValuesDescription", (Object)value.getXAxisDescription());
        gen.writeObjectField("yValuesDescription", (Object)value.getYAxisDescription());
        gen.writeEndObject();
    }
}

