/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.internal.core.ProblemMarkerFilterDesc;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ProblemMarkerFilterManager {
    private static final String EXTENSION_POINT = "ProblemMarkerFilter";
    private static final ProblemMarkerFilterManager INSTANCE = new ProblemMarkerFilterManager();
    private final List<ProblemMarkerFilterDesc> filters = new ArrayList<ProblemMarkerFilterDesc>();
    private final Map<IProject, List<ProblemMarkerFilterDesc>> filtersCache = new WeakHashMap<IProject, List<ProblemMarkerFilterDesc>>();
    private Map<IResource, ProblemMarkerInfo> lastAcceptedProblemMarker = new HashMap<IResource, ProblemMarkerInfo>();

    public static ProblemMarkerFilterManager getInstance() {
        return INSTANCE;
    }

    private ProblemMarkerFilterManager() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor("org.eclipse.cdt.core", EXTENSION_POINT);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement element = extensions[i];
            ProblemMarkerFilterDesc filterDesc = new ProblemMarkerFilterDesc(element);
            this.filters.add(filterDesc);
            ++i;
        }
    }

    public ProblemMarkerInfo getLastProblemMarker(IResource resource) {
        return this.lastAcceptedProblemMarker.get(resource);
    }

    public boolean acceptMarker(ProblemMarkerInfo markerInfo) {
        IProject project = markerInfo.file.getProject();
        if (project == null || !project.isOpen()) {
            this.lastAcceptedProblemMarker.put(markerInfo.file, markerInfo);
            return true;
        }
        List<ProblemMarkerFilterDesc> enabledFilters = this.findEnabledFilters(project);
        for (ProblemMarkerFilterDesc filterDesc : enabledFilters) {
            if (filterDesc.getFilter().acceptMarker(markerInfo)) continue;
            return false;
        }
        this.lastAcceptedProblemMarker.put(markerInfo.file, markerInfo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProblemMarkerFilterDesc> findEnabledFilters(IProject project) {
        Map<IProject, List<ProblemMarkerFilterDesc>> map = this.filtersCache;
        synchronized (map) {
            List<ProblemMarkerFilterDesc> result = this.filtersCache.get(project);
            if (result == null) {
                result = new ArrayList<ProblemMarkerFilterDesc>();
                for (ProblemMarkerFilterDesc filterDesc : this.filters) {
                    if (!filterDesc.matches(project)) continue;
                    result.add(filterDesc);
                }
                this.filtersCache.put(project, result);
            }
            return result;
        }
    }
}

