/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.cdt.internal.core.natives.CNativePlugin;
import org.eclipse.cdt.internal.core.natives.Messages;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class ProcessFactory {
    private static ProcessFactory instance;
    private boolean hasSpawner = false;
    private Runtime runtime;

    private String[] modifyCmdArrayIfFlatpak(String[] cmdarray) {
        if (System.getenv("FLATPAK_SANDBOX_DIR") != null) {
            String[] newArray = new String[cmdarray.length + 3];
            System.arraycopy(cmdarray, 0, newArray, 3, cmdarray.length);
            newArray[0] = "flatpak-spawn";
            newArray[1] = "--host";
            newArray[2] = "--watch-bus";
            cmdarray = newArray;
        }
        return cmdarray;
    }

    private static TreeMap<String, String> newEmptyEnvironment() {
        TreeMap<String, String> environment = Platform.getOS().equals("win32") ? new TreeMap(String.CASE_INSENSITIVE_ORDER) : new TreeMap<String, String>();
        return environment;
    }

    private static TreeMap<String, String> getDefaultEnvironment() {
        TreeMap<String, String> environment = ProcessFactory.newEmptyEnvironment();
        Map<String, String> env = new ProcessBuilder(new String[0]).environment();
        environment.putAll(env);
        return environment;
    }

    private static TreeMap<String, String> envpToEnvMap(String[] envp) {
        TreeMap<String, String> environment;
        if (envp != null) {
            environment = ProcessFactory.newEmptyEnvironment();
            String[] stringArray = envp;
            int n = envp.length;
            int n2 = 0;
            while (n2 < n) {
                String envstring = stringArray[n2];
                int eqlsign = envstring.indexOf(61);
                if (eqlsign != -1) {
                    environment.put(envstring.substring(0, eqlsign), envstring.substring(eqlsign + 1));
                }
                ++n2;
            }
        } else {
            environment = ProcessFactory.getDefaultEnvironment();
        }
        return environment;
    }

    private static void appendEnvMapComparison(StringBuilder sb, TreeMap<String, String> environmentA, TreeMap<String, String> environmentB) {
        TreeMap<String, String> environmentC = ProcessFactory.newEmptyEnvironment();
        environmentC.putAll(environmentA);
        environmentC.putAll(environmentB);
        for (Map.Entry<String, String> entry : environmentC.entrySet()) {
            String valueB;
            String key = entry.getKey();
            if (environmentA.containsKey(key)) {
                String valueA = environmentA.get(key);
                if (environmentB.containsKey(key)) {
                    valueB = environmentB.get(key);
                    int result = valueA.compareTo(valueB);
                    if (result == 0) {
                        sb.append(' ');
                        sb.append(key);
                        sb.append('=');
                        sb.append(valueA);
                        sb.append('\n');
                        continue;
                    }
                    sb.append('-');
                    sb.append(key);
                    sb.append('=');
                    sb.append(valueA);
                    sb.append('\n');
                    sb.append('+');
                    sb.append(key);
                    sb.append('=');
                    sb.append(valueB);
                    sb.append('\n');
                    continue;
                }
                sb.append('-');
                sb.append(key);
                sb.append('=');
                sb.append(valueA);
                sb.append('\n');
                continue;
            }
            valueB = environmentB.get(key);
            sb.append('+');
            sb.append(key);
            sb.append('=');
            sb.append(valueB);
            sb.append('\n');
        }
    }

    private ProcessFactory() {
        String OS = System.getProperty("os.name").toLowerCase();
        this.runtime = Runtime.getRuntime();
        try {
            if (OS != null && OS.equals("windows 98")) {
                this.hasSpawner = false;
            } else {
                System.loadLibrary("spawner");
                this.hasSpawner = true;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (UnsatisfiedLinkError e) {
            CNativePlugin.log(e.getMessage());
        }
    }

    public static ProcessFactory getFactory() {
        if (instance == null) {
            instance = new ProcessFactory();
        }
        return instance;
    }

    @Deprecated
    public Process exec(String cmd) throws IOException {
        Process p = new Builder(cmd).start();
        return p;
    }

    public Process exec(String[] cmdarray) throws IOException {
        Process p = new Builder(cmdarray).start();
        return p;
    }

    public Process exec(String[] cmdarray, int gracefulExitTimeMs) throws IOException {
        Process p = new Builder(cmdarray).gracefulExitTimeMs(gracefulExitTimeMs).start();
        return p;
    }

    public Process exec(String[] cmdarray, String[] envp) throws IOException {
        Process p = new Builder(cmdarray).environment(envp).start();
        return p;
    }

    public Process exec(String[] cmdarray, String[] envp, int gracefulExitTimeMs) throws IOException {
        Process p = new Builder(cmdarray).environment(envp).gracefulExitTimeMs(gracefulExitTimeMs).start();
        return p;
    }

    @Deprecated
    public Process exec(String cmd, String[] envp) throws IOException {
        Process p = new Builder(cmd).environment(envp).start();
        return p;
    }

    @Deprecated
    public Process exec(String cmd, String[] envp, File dir) throws IOException {
        Process p = new Builder(cmd).environment(envp).directory(dir).start();
        return p;
    }

    public Process exec(String[] cmdarray, String[] envp, File dir) throws IOException {
        Process p = new Builder(cmdarray).environment(envp).directory(dir).start();
        return p;
    }

    public Process exec(String[] cmdarray, String[] envp, File dir, int gracefulExitTimeMs) throws IOException {
        Process p = new Builder(cmdarray).environment(envp).directory(dir).gracefulExitTimeMs(gracefulExitTimeMs).start();
        return p;
    }

    public Process exec(String[] cmdarray, String[] envp, File dir, PTY pty) throws IOException {
        Process p = new Builder(cmdarray).environment(envp).directory(dir).pty(pty).start();
        return p;
    }

    public Process exec(String[] cmdarray, String[] envp, File dir, PTY pty, int gracefulExitTimeMs) throws IOException {
        Process p = new Builder(cmdarray).environment(envp).directory(dir).pty(pty).gracefulExitTimeMs(gracefulExitTimeMs).start();
        return p;
    }

    private class Builder {
        String[] cmdarray;
        String[] envp;
        File dir;
        boolean use_pty;
        PTY pty;
        boolean has_gracefulExitTimeMs;
        int gracefulExitTimeMs;

        public Builder(String cmd) throws IOException {
            if (cmd.isEmpty()) {
                throw new IllegalArgumentException("Empty command");
            }
            StringTokenizer st = new StringTokenizer(cmd);
            this.cmdarray = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                this.cmdarray[i] = st.nextToken();
                ++i;
            }
            this.cmdarray = ProcessFactory.this.modifyCmdArrayIfFlatpak(this.cmdarray);
        }

        public Builder(String[] cmdarray) throws IOException {
            if (cmdarray.length == 0 || cmdarray[0].isEmpty()) {
                throw new IllegalArgumentException("Empty command");
            }
            this.cmdarray = cmdarray;
            this.cmdarray = ProcessFactory.this.modifyCmdArrayIfFlatpak(this.cmdarray);
        }

        public Builder environment(String[] envp) {
            this.envp = envp;
            return this;
        }

        public Builder directory(File directory) {
            this.dir = directory;
            return this;
        }

        public Builder pty(PTY pty) {
            this.use_pty = true;
            this.pty = pty;
            return this;
        }

        public Builder gracefulExitTimeMs(int gracefulExitTimeMs) {
            this.has_gracefulExitTimeMs = true;
            this.gracefulExitTimeMs = gracefulExitTimeMs;
            return this;
        }

        private StringBuilder debug() {
            StringBuilder sb = new StringBuilder();
            sb.append("command :\n");
            int i = 0;
            while (i < this.cmdarray.length) {
                sb.append(i);
                sb.append(" : \"");
                sb.append(this.cmdarray[i]);
                sb.append("\"\n");
                ++i;
            }
            sb.append("\n\n");
            sb.append("directory :\n");
            if (this.dir != null) {
                String pathString = this.dir.toString();
                sb.append(pathString);
                sb.append('\n');
                Path path = new Path(pathString);
                String pathDevice = path.getDevice();
                String[] pathSegments = path.segments();
                if (pathDevice != null) {
                    sb.append("device : ");
                    sb.append(pathDevice);
                    sb.append('\n');
                }
                sb.append("segments : \n");
                int i2 = 0;
                while (i2 < pathSegments.length) {
                    sb.append(i2);
                    sb.append(" : ");
                    sb.append(pathSegments[i2]);
                    sb.append('\n');
                    ++i2;
                }
            } else {
                sb.append("not specified\n");
            }
            sb.append("\n\n");
            TreeMap<String, String> environmentA = ProcessFactory.getDefaultEnvironment();
            TreeMap<String, String> environmentB = ProcessFactory.envpToEnvMap(this.envp);
            sb.append("environment :\n");
            ProcessFactory.appendEnvMapComparison(sb, environmentA, environmentB);
            sb.append("\n\n");
            if (this.use_pty) {
                sb.append("use pty : ");
                sb.append(this.pty.toString());
                sb.append("\n\n");
            }
            if (this.has_gracefulExitTimeMs) {
                sb.append("has gracefulExitTimeMs : ");
                sb.append(this.gracefulExitTimeMs);
                sb.append("\n\n");
            }
            return sb;
        }

        public Process start() throws IOException {
            Process p;
            if (ProcessFactory.this.hasSpawner) {
                p = this.use_pty ? (this.has_gracefulExitTimeMs ? new Spawner(this.cmdarray, this.envp, this.dir, this.pty, this.gracefulExitTimeMs) : new Spawner(this.cmdarray, this.envp, this.dir, this.pty)) : (this.has_gracefulExitTimeMs ? new Spawner(this.cmdarray, this.envp, this.dir, this.gracefulExitTimeMs) : new Spawner(this.cmdarray, this.envp, this.dir));
            } else {
                if (this.use_pty || this.has_gracefulExitTimeMs) {
                    throw new UnsupportedOperationException(Messages.Util_exception_cannotCreatePty);
                }
                p = ProcessFactory.this.runtime.exec(this.cmdarray, this.envp, this.dir);
            }
            return p;
        }
    }
}

