/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.request;

import java.util.concurrent.CountDownLatch;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.TmfCoreTracer;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;

public abstract class TmfEventRequest
implements ITmfEventRequest {
    private static int fRequestNumber = 0;
    private final Class<? extends ITmfEvent> fDataType;
    private final ITmfEventRequest.ExecutionType fExecType;
    private final int fRequestId;
    private final TmfTimeRange fRange;
    protected long fIndex;
    protected int fNbRequested;
    private int fNbRead;
    private final CountDownLatch fStartedLatch = new CountDownLatch(1);
    private final CountDownLatch fCompletedLatch = new CountDownLatch(1);
    private volatile boolean fRequestFailed = false;
    private volatile boolean fRequestCanceled = false;
    private ITmfFilter fEventFilter;
    private int fDependencyLevel;
    private @Nullable Throwable fFailureCause;

    public TmfEventRequest(Class<? extends ITmfEvent> dataType, long index, int nbRequested, ITmfEventRequest.ExecutionType priority) {
        this(dataType, TmfTimeRange.ETERNITY, index, nbRequested, priority);
    }

    public TmfEventRequest(Class<? extends ITmfEvent> dataType, TmfTimeRange range, long index, int nbRequested, ITmfEventRequest.ExecutionType priority) {
        this(dataType, range, index, nbRequested, priority, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TmfEventRequest(Class<? extends ITmfEvent> dataType, TmfTimeRange range, long index, int nbRequested, ITmfEventRequest.ExecutionType priority, int dependencyLevel) {
        Class<TmfEventRequest> clazz = TmfEventRequest.class;
        synchronized (TmfEventRequest.class) {
            this.fRequestId = fRequestNumber++;
            // ** MonitorExit[var8_7] (shouldn't be in output)
            this.fDataType = dataType;
            this.fIndex = index;
            this.fNbRequested = nbRequested;
            this.fExecType = priority;
            this.fRange = range;
            this.fNbRead = 0;
            this.fDependencyLevel = dependencyLevel;
            if (TmfCoreTracer.isRequestTraced()) {
                String type = this.getClass().getName();
                type = type.substring(type.lastIndexOf(46) + 1);
                String message = "CREATED " + (this.getExecType() == ITmfEventRequest.ExecutionType.BACKGROUND ? "(BG)" : "(FG)") + " Type=" + type + " Index=" + this.getIndex() + " NbReq=" + this.getNbRequested() + " Range=" + String.valueOf(this.getRange()) + " DataType=" + this.getDataType().getSimpleName() + " DependencyLevel= " + this.fDependencyLevel;
                TmfCoreTracer.traceRequest(this.fRequestId, message);
            }
            return;
        }
    }

    @Override
    public int getRequestId() {
        return this.fRequestId;
    }

    @Override
    public long getIndex() {
        return this.fIndex;
    }

    @Override
    public ITmfEventRequest.ExecutionType getExecType() {
        return this.fExecType;
    }

    @Override
    public int getNbRequested() {
        return this.fNbRequested;
    }

    @Override
    public synchronized int getNbRead() {
        return this.fNbRead;
    }

    @Override
    public synchronized boolean isRunning() {
        return this.fStartedLatch.getCount() <= 0L && this.fCompletedLatch.getCount() > 0L;
    }

    @Override
    public synchronized boolean isCompleted() {
        return this.fCompletedLatch.getCount() <= 0L;
    }

    @Override
    public synchronized boolean isFailed() {
        return this.fRequestFailed;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.fRequestCanceled;
    }

    @Override
    public Class<? extends ITmfEvent> getDataType() {
        return this.fDataType;
    }

    @Override
    public TmfTimeRange getRange() {
        return this.fRange;
    }

    @Override
    public ITmfFilter getProviderFilter() {
        return this.fEventFilter;
    }

    @Override
    public void setProviderFilter(ITmfFilter provider) {
        this.fEventFilter = provider;
    }

    @Override
    public int getDependencyLevel() {
        return this.fDependencyLevel;
    }

    @Override
    public @Nullable Throwable getFailureCause() {
        return this.fFailureCause;
    }

    protected void setIndex(int index) {
        this.fIndex = index;
    }

    @Override
    public void setStartIndex(int index) {
        this.setIndex(index);
    }

    @Override
    public void handleData(ITmfEvent event) {
        ++this.fNbRead;
    }

    @Override
    public void handleStarted() {
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this.getRequestId(), "STARTED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCompleted() {
        boolean requestFailed = false;
        boolean requestCanceled = false;
        TmfEventRequest tmfEventRequest = this;
        synchronized (tmfEventRequest) {
            requestFailed = this.fRequestFailed;
            requestCanceled = this.fRequestCanceled;
        }
        if (requestFailed) {
            this.handleFailure();
        } else if (requestCanceled) {
            this.handleCancel();
        } else {
            this.handleSuccess();
        }
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this.getRequestId(), "COMPLETED (" + this.fNbRead + " events read)");
        }
    }

    @Override
    public void handleSuccess() {
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this.getRequestId(), "SUCCEEDED");
        }
    }

    @Override
    public void handleFailure() {
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this.getRequestId(), "FAILED");
        }
    }

    @Override
    public void handleCancel() {
        if (TmfCoreTracer.isRequestTraced()) {
            TmfCoreTracer.traceRequest(this.getRequestId(), "CANCELLED");
        }
    }

    public void waitForStart() throws InterruptedException {
        this.fStartedLatch.await();
    }

    @Override
    public void waitForCompletion() throws InterruptedException {
        this.fCompletedLatch.await();
    }

    @Override
    public synchronized void start() {
        this.handleStarted();
        this.fStartedLatch.countDown();
    }

    @Override
    public synchronized void done() {
        this.handleCompleted();
        this.fCompletedLatch.countDown();
    }

    @Override
    public void fail(Exception e) {
        this.fRequestFailed = true;
        this.fFailureCause = e;
        this.done();
    }

    @Override
    public void cancel() {
        this.fRequestCanceled = true;
        this.done();
    }

    public String toString() {
        String name = this.getClass().getName();
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            name = name.substring(dot + 1);
        }
        return "[" + name + "(" + this.getRequestId() + "," + this.getDataType().getSimpleName() + "," + String.valueOf((Object)this.getExecType()) + "," + String.valueOf(this.getRange()) + "," + this.getIndex() + "," + this.getNbRequested() + "," + this.getDependencyLevel() + ")]";
    }
}

