/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;

public class TimeGraphEntryModelSerializer
extends StdSerializer<ITimeGraphEntryModel> {
    private static final long serialVersionUID = -4359431726167157401L;

    protected TimeGraphEntryModelSerializer() {
        super(ITimeGraphEntryModel.class);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void serialize(ITimeGraphEntryModel value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Multimap metadata;
        gen.writeStartObject();
        gen.writeNumberField("id", value.getId());
        gen.writeNumberField("parentId", value.getParentId());
        if (value.getStyle() != null) {
            gen.writeObjectField("style", (Object)value.getStyle());
        }
        gen.writeArrayFieldStart("labels");
        for (String label : value.getLabels()) {
            gen.writeString(label);
        }
        gen.writeEndArray();
        gen.writeNumberField("start", value.getStartTime());
        gen.writeNumberField("end", value.getEndTime());
        if (value.hasRowModel()) {
            gen.writeBooleanField("hasData", value.hasRowModel());
        }
        if (!(metadata = value.getMetadata()).isEmpty()) {
            HashMap<String, Collection> serializedMap = new HashMap<String, Collection>();
            for (Map.Entry entry : metadata.asMap().entrySet()) {
                @NonNull Collection collection = (Collection)entry.getValue();
                if (collection == null) continue;
                if (!collection.stream().allMatch(String.class::isInstance)) {
                    if (!collection.stream().allMatch(Number.class::isInstance)) continue;
                }
                serializedMap.put((String)entry.getKey(), collection);
            }
            gen.writeObjectField("metadata", serializedMap);
        }
        gen.writeEndObject();
    }
}

