/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.rocm.core.trace;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old.ApiEventHandler;
import org.eclipse.tracecompass.incubator.rocm.core.trace.Messages;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;

@NonNullByDefault
public class RocmAspects {
    private static final ITmfEventAspect<Integer> PID_ASPECT = new ITmfEventAspect<Integer>(){

        public String getName() {
            return Messages.getMessage(Messages.AspectName_PID);
        }

        public String getHelpText() {
            return "";
        }

        public @Nullable Integer resolve(ITmfEvent event) {
            return (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"pid"});
        }
    };
    private static final ITmfEventAspect<Integer> TID_ASPECT = new ITmfEventAspect<Integer>(){

        public String getName() {
            return Messages.getMessage(Messages.AspectName_TID);
        }

        public String getHelpText() {
            return "";
        }

        public @Nullable Integer resolve(ITmfEvent event) {
            return (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"tid"});
        }
    };
    private static final ITmfEventAspect<Integer> QUEUE_ID_ASPECT = new ITmfEventAspect<Integer>(){

        public String getName() {
            return Messages.getMessage(Messages.AspectName_QueueID);
        }

        public String getHelpText() {
            return "";
        }

        public @Nullable Integer resolve(ITmfEvent event) {
            return (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"queue_id"});
        }
    };
    private static final ITmfEventAspect<Integer> STREAM_ID_ASPECT = new ITmfEventAspect<Integer>(){

        public String getName() {
            return Messages.getMessage(Messages.AspectName_StreamID);
        }

        public String getHelpText() {
            return "";
        }

        public @Nullable Integer resolve(ITmfEvent event) {
            return (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"stream_id"});
        }
    };
    private static final ITmfEventAspect<Integer> QUEUE_INDEX_ASPECT = new ITmfEventAspect<Integer>(){

        public String getName() {
            return Messages.getMessage(Messages.AspectName_QueueIndex);
        }

        public String getHelpText() {
            return "";
        }

        public @Nullable Integer resolve(ITmfEvent event) {
            return (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"queue_index"});
        }
    };
    private static final ITmfEventAspect<String> FUNCTION_NAME_ASPECT = new ITmfEventAspect<String>(){

        public String getName() {
            return Messages.getMessage(Messages.AspectName_FunctionName);
        }

        public String getHelpText() {
            return "";
        }

        public @Nullable String resolve(ITmfEvent event) {
            if (event.getName().endsWith("_api")) {
                return ApiEventHandler.getFunctionApiName(event);
            }
            String name = (String)event.getContent().getFieldValue(String.class, new String[]{"name"});
            if (name == null) {
                name = (String)event.getContent().getFieldValue(String.class, new String[]{"kernel_name"});
            }
            return name;
        }
    };
    private static final List<ITmfEventAspect<?>> ASPECTS = ImmutableList.of(RocmAspects.getPIDAspect(), RocmAspects.getTIDAspect(), RocmAspects.getQueueIDAspect(), RocmAspects.getStreamIDAspect(), RocmAspects.getQueueIndexAspect(), RocmAspects.getFunctionNameAspect());

    private RocmAspects() {
    }

    public static ITmfEventAspect<Integer> getPIDAspect() {
        return PID_ASPECT;
    }

    public static ITmfEventAspect<Integer> getTIDAspect() {
        return TID_ASPECT;
    }

    public static ITmfEventAspect<Integer> getQueueIDAspect() {
        return QUEUE_ID_ASPECT;
    }

    public static ITmfEventAspect<Integer> getStreamIDAspect() {
        return STREAM_ID_ASPECT;
    }

    public static ITmfEventAspect<Integer> getQueueIndexAspect() {
        return QUEUE_INDEX_ASPECT;
    }

    public static ITmfEventAspect<String> getFunctionNameAspect() {
        return FUNCTION_NAME_ASPECT;
    }

    public static List<ITmfEventAspect<?>> getAllAspects() {
        return ASPECTS;
    }
}

