/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.lttng2.ust.extras.core.pthread;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.building.AbstractTraceEventHandler;
import org.eclipse.tracecompass.analysis.graph.core.building.ITraceEventHandler;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.IOsExecutionGraphHandlerBuilder;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsExecutionGraphProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class PThreadLockGraphHandler
extends AbstractTraceEventHandler {
    private static final Pattern UNLOCK_EVENT = Pattern.compile("lttng_ust_pthread:pthread_.*_unlock");
    private static final Pattern ACQUIRE_LOCK_EVENT = Pattern.compile("lttng_ust_pthread:pthread_.*_lock_acq");
    private static final Pattern REQUEST_LOCK_EVENT = Pattern.compile("lttng_ust_pthread:pthread_.*_lock_req");
    private static final String MUTEX_FIELD = "mutex";
    private final OsExecutionGraphProvider fProvider;
    private final Table<Integer, Long, TmfVertex> fLastRequest;
    private final Map<Long, LastLockOwner> fLastLockOwner = new HashMap<Long, LastLockOwner>();

    public PThreadLockGraphHandler(OsExecutionGraphProvider provider, int priority) {
        super(priority);
        this.fProvider = provider;
        this.fLastRequest = HashBasedTable.create();
    }

    private OsWorker getOrCreateKernelWorker(ITmfEvent event, Integer tid) {
        HostThread ht = new HostThread(event.getTrace().getHostId(), tid);
        OsWorker worker = this.fProvider.getSystem().findWorker(ht);
        if (worker != null) {
            return worker;
        }
        worker = new OsWorker(ht, "kernel/" + String.valueOf(tid), event.getTimestamp().getValue());
        worker.setStatus(ProcessStatus.RUN);
        this.fProvider.getSystem().addWorker(worker);
        return worker;
    }

    public void handleEvent(ITmfEvent event) {
        String name = event.getName();
        if (UNLOCK_EVENT.matcher(name).matches()) {
            this.handleUnlockEvent(event);
        } else if (REQUEST_LOCK_EVENT.matcher(name).matches()) {
            this.handleRequestLockEvent(event);
        } else if (ACQUIRE_LOCK_EVENT.matcher(name).matches()) {
            this.handleAcquireLockEvent(event);
        }
    }

    private void handleAcquireLockEvent(ITmfEvent event) {
        Integer tid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        if (tid == null) {
            return;
        }
        Long fieldValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{MUTEX_FIELD});
        if (fieldValue == null) {
            return;
        }
        OsWorker worker = this.getOrCreateKernelWorker(event, tid);
        TmfVertex lastReqVertex = (TmfVertex)this.fLastRequest.get((Object)tid, (Object)fieldValue);
        if (lastReqVertex == null) {
            return;
        }
        LastLockOwner lastOwner = this.fLastLockOwner.get(fieldValue);
        if (lastOwner != null && lastOwner.fTid != tid && lastOwner.fVertex.getTs() > lastReqVertex.getTs()) {
            TmfGraph graph = Objects.requireNonNull(this.fProvider.getAssignedGraph());
            graph.append((IGraphWorker)worker, lastReqVertex, TmfEdge.EdgeType.RUNNING);
            TmfVertex unblockVertex = new TmfVertex(event.getTimestamp().toNanos());
            graph.append((IGraphWorker)worker, unblockVertex, TmfEdge.EdgeType.BLOCKED);
            lastOwner.fVertex.linkVertical(unblockVertex);
        }
    }

    private void handleRequestLockEvent(ITmfEvent event) {
        Integer tid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        if (tid == null) {
            return;
        }
        Long fieldValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{MUTEX_FIELD});
        if (fieldValue == null) {
            return;
        }
        TmfVertex vertex = new TmfVertex(event.getTimestamp().toNanos());
        this.fLastRequest.put((Object)tid, (Object)fieldValue, (Object)vertex);
    }

    private void handleUnlockEvent(ITmfEvent event) {
        Integer tid = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        if (tid == null) {
            return;
        }
        Long fieldValue = (Long)event.getContent().getFieldValue(Long.class, new String[]{MUTEX_FIELD});
        if (fieldValue == null) {
            return;
        }
        OsWorker worker = this.getOrCreateKernelWorker(event, tid);
        TmfGraph graph = Objects.requireNonNull(this.fProvider.getAssignedGraph());
        TmfVertex vertex = new TmfVertex(event.getTimestamp().toNanos());
        graph.append((IGraphWorker)worker, vertex, TmfEdge.EdgeType.RUNNING);
        this.fLastLockOwner.put(fieldValue, new LastLockOwner(tid, vertex));
    }

    public static class HandlerBuilderPThreadLock
    implements IOsExecutionGraphHandlerBuilder {
        public ITraceEventHandler createHandler(@NonNull OsExecutionGraphProvider provider, int priority) {
            return new PThreadLockGraphHandler(provider, priority);
        }
    }

    private static class LastLockOwner {
        public final Integer fTid;
        public final TmfVertex fVertex;

        public LastLockOwner(Integer tid, TmfVertex vertex) {
            this.fTid = tid;
            this.fVertex = vertex;
        }
    }
}

