/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.callstack.core.callgraph;

import java.util.Collection;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.ICalledFunction;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderUtils;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public final class SymbolAspect
implements ISegmentAspect {
    public static final ISegmentAspect SYMBOL_ASPECT = new SymbolAspect();

    public @NonNull String getName() {
        return String.valueOf("Function name");
    }

    public @NonNull String getHelpText() {
        return String.valueOf("Function name");
    }

    public @Nullable Comparator<?> getComparator() {
        return new Comparator<ISegment>(){

            @Override
            public int compare(@Nullable ISegment o1, @Nullable ISegment o2) {
                if (o1 == null || o2 == null) {
                    throw new IllegalArgumentException();
                }
                return Long.compare(o1.getLength(), o2.getLength());
            }
        };
    }

    public @Nullable Object resolve(@NonNull ISegment segment) {
        if (segment instanceof ICalledFunction) {
            ICalledFunction calledFunction = (ICalledFunction)segment;
            ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
            if (trace != null) {
                Object symbol = calledFunction.getSymbol();
                if (symbol instanceof Long) {
                    Long longAddress = (Long)symbol;
                    Collection providers = SymbolProviderManager.getInstance().getSymbolProviders(trace);
                    long time = segment.getStart();
                    int pid = calledFunction.getProcessId();
                    if (pid > 0) {
                        return SymbolProviderUtils.getSymbolText((Collection)providers, (int)pid, (long)time, (long)longAddress);
                    }
                    return SymbolProviderUtils.getSymbolText((Collection)providers, (long)longAddress);
                }
                return String.valueOf(symbol);
            }
        }
        return null;
    }
}

