/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class SourceElementWorkbenchAdapter
implements IWorkbenchAdapter {
    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object o) {
        if (o instanceof LocalFileStorage || o instanceof ZipEntryStorage) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
        }
        return null;
    }

    public String getLabel(Object o) {
        if (o instanceof LocalFileStorage) {
            LocalFileStorage storage = (LocalFileStorage)o;
            IPath path = storage.getFullPath();
            return SourceElementWorkbenchAdapter.getQualifiedName(path);
        }
        if (o instanceof ZipEntryStorage) {
            ZipEntryStorage storage = (ZipEntryStorage)o;
            StringBuilder buffer = new StringBuilder();
            buffer.append(storage.getZipEntry().getName());
            buffer.append(" - ");
            buffer.append(storage.getArchivePath());
            return buffer.toString();
        }
        return "";
    }

    public Object getParent(Object o) {
        return null;
    }

    public static String getQualifiedName(IPath path) {
        StringBuilder buffer = new StringBuilder();
        String[] segments = path.segments();
        if (segments.length > 0) {
            buffer.append(path.lastSegment());
            if (segments.length > 1) {
                buffer.append(" - ");
                if (path.getDevice() != null) {
                    buffer.append(path.getDevice());
                }
                int i = 0;
                while (i < segments.length - 1) {
                    buffer.append(File.separatorChar);
                    buffer.append(segments[i]);
                    ++i;
                }
            }
            return buffer.toString();
        }
        return "";
    }
}

