/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.extension.RegistryReader;
import org.osgi.framework.Bundle;

public class ExtendedConfigurationBuilder
extends RegistryReader {
    public static final String CONTENTOUTLINECONFIGURATION = "contentOutlineConfiguration";
    public static final String PROPERTYSHEETCONFIGURATION = "propertySheetConfiguration";
    public static final String SOURCEVIEWERCONFIGURATION = "sourceViewerConfiguration";
    public static final String DOCUMENTATIONTEXTHOVER = "documentationTextHover";
    public static final String DOUBLECLICKSTRATEGY = "doubleClickStrategy";
    public static final String QUICKOUTLINECONFIGURATION = "quickOutlineConfiguration";
    private static final String ATT_CLASS = "class";
    private static final String ATT_TARGET = "target";
    private static final String ATT_TYPE = "type";
    private static final String CONFIGURATION = "provisionalConfiguration";
    private static Map<String, List<IConfigurationElement>> configurationMap = null;
    private static final boolean debugTime = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/extendedconfigurationbuilder/time"));
    private static final String DEFINITION = "provisionalDefinition";
    private static final String EP_EXTENDEDCONFIGURATION = "editorConfiguration";
    private static ExtendedConfigurationBuilder instance = null;
    public static final String VALUE = "value";
    long time0 = 0L;

    static <T> T createExtension(final IConfigurationElement element, final String classAttribute, final String targetID) {
        final Object[] result = new Object[1];
        String pluginId = element.getDeclaringExtension().getNamespace();
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle.getState() == 32) {
            try {
                result[0] = element.createExecutableExtension(classAttribute);
            }
            catch (Exception e) {
                Logger.logException("error loading class " + classAttribute + " for " + targetID, e);
            }
        } else {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        result[0] = element.createExecutableExtension(classAttribute);
                    }
                    catch (Exception e) {
                        Logger.logException("error loading class " + classAttribute + " for " + targetID, e);
                    }
                }
            });
        }
        return (T)result[0];
    }

    public static synchronized ExtendedConfigurationBuilder getInstance() {
        if (instance == null) {
            instance = new ExtendedConfigurationBuilder();
        }
        return instance;
    }

    private ExtendedConfigurationBuilder() {
    }

    private <T> List<T> createConfigurations(List<IConfigurationElement> configurations, String extensionType, String targetID) {
        if (configurations == null) {
            return new ArrayList(0);
        }
        ArrayList<T> result = new ArrayList<T>(1);
        int i = 0;
        while (i < configurations.size()) {
            IConfigurationElement element = configurations.get(i);
            if (element.getName().equals(extensionType) || element.getName().equals(CONFIGURATION) && extensionType.equals(element.getAttribute(ATT_TYPE))) {
                String[] targets = StringUtils.unpack((String)element.getAttribute(ATT_TARGET));
                int j = 0;
                while (j < targets.length) {
                    T o;
                    if (targetID.equals(targets[j].trim()) && (o = ExtendedConfigurationBuilder.createExtension(element, ATT_CLASS, targetID)) != null) {
                        result.add(o);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    private IConfigurationElement[] findConfigurationElements(List<IConfigurationElement> configurations, String extensionType, String targetID) {
        if (configurations == null) {
            return new IConfigurationElement[0];
        }
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>(1);
        int i = 0;
        while (i < configurations.size()) {
            IConfigurationElement element = configurations.get(i);
            if (element.getName().equals(extensionType) || element.getName().equals(DEFINITION) && extensionType.equals(element.getAttribute(ATT_TYPE))) {
                String[] targets = StringUtils.unpack((String)element.getAttribute(ATT_TARGET));
                int j = 0;
                while (j < targets.length) {
                    if (targetID.equals(targets[j].trim())) {
                        result.add(element);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IConfigurationElement[0]);
    }

    public Object getConfiguration(String extensionType, String targetID) {
        if (targetID == null || targetID.length() == 0) {
            return null;
        }
        List configurations = this.getConfigurations(extensionType, targetID);
        if (configurations.isEmpty()) {
            return null;
        }
        return configurations.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getConfigurations(String extensionType, String targetID) {
        if (targetID == null || targetID.length() == 0) {
            return new ArrayList(0);
        }
        if (configurationMap == null) {
            Map<String, List<IConfigurationElement>> map = configurationMap = new HashMap<String, List<IConfigurationElement>>(0);
            synchronized (map) {
                this.readRegistry(Platform.getExtensionRegistry(), "org.eclipse.wst.sse.ui", EP_EXTENDEDCONFIGURATION);
                if (debugTime) {
                    System.out.println(String.valueOf(this.getClass().getName()) + "#readRegistry():  " + (System.currentTimeMillis() - this.time0) + "ms");
                    this.time0 = System.currentTimeMillis();
                }
            }
        }
        List<IConfigurationElement> extensions = configurationMap.get(extensionType);
        List<T> configurations = this.createConfigurations(extensions, extensionType, targetID);
        if (debugTime) {
            if (!configurations.isEmpty()) {
                System.out.println(String.valueOf(this.getClass().getName()) + "#getConfiguration(" + extensionType + ", " + targetID + "): configurations loaded in " + (System.currentTimeMillis() - this.time0) + "ms");
            } else {
                System.out.println(String.valueOf(this.getClass().getName()) + "#getConfiguration(" + extensionType + ", " + targetID + "): ran in " + (System.currentTimeMillis() - this.time0) + "ms");
            }
        }
        return configurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDefinitions(String extensionType, String targetID) {
        if (targetID == null || targetID.length() == 0) {
            return new String[0];
        }
        if (debugTime) {
            this.time0 = System.currentTimeMillis();
        }
        if (configurationMap == null) {
            Map<String, List<IConfigurationElement>> map = configurationMap = new HashMap<String, List<IConfigurationElement>>(0);
            synchronized (map) {
                this.readRegistry(Platform.getExtensionRegistry(), "org.eclipse.wst.sse.ui", EP_EXTENDEDCONFIGURATION);
                if (debugTime) {
                    System.out.println(String.valueOf(this.getClass().getName()) + "#readRegistry():  " + (System.currentTimeMillis() - this.time0) + "ms");
                    this.time0 = System.currentTimeMillis();
                }
            }
        }
        List<IConfigurationElement> definitions = configurationMap.get(extensionType);
        IConfigurationElement[] elements = this.findConfigurationElements(definitions, extensionType, targetID);
        String[] values = new String[elements.length];
        int i = 0;
        while (i < values.length) {
            values[i] = elements[i].getAttribute(VALUE);
            ++i;
        }
        if (debugTime) {
            if (values.length > 0) {
                System.out.println(String.valueOf(this.getClass().getName()) + "#getDefinitions(" + extensionType + ", " + targetID + "): definition loaded in " + (System.currentTimeMillis() - this.time0) + "ms");
            } else {
                System.out.println(String.valueOf(this.getClass().getName()) + "#getDefinitions(" + extensionType + ", " + targetID + "): ran in " + (System.currentTimeMillis() - this.time0) + "ms");
            }
        }
        return values;
    }

    @Override
    protected boolean readElement(IConfigurationElement element) {
        List<IConfigurationElement> configurations;
        String name = element.getName();
        if (name.equals(CONFIGURATION) || name.equals(DEFINITION)) {
            name = element.getAttribute(ATT_TYPE);
        }
        if ((configurations = configurationMap.get(name)) == null) {
            configurations = new ArrayList<IConfigurationElement>(1);
            configurationMap.put(name, configurations);
        }
        configurations.add(element);
        return true;
    }
}

