/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;

public class ModuleCategoryDefinition {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String PARENT = "parent";
    private final IConfigurationElement fConfig;

    public ModuleCategoryDefinition(IConfigurationElement config) {
        this.fConfig = config;
    }

    public String getId() {
        return this.fConfig.getAttribute(ID) != null ? this.fConfig.getAttribute(ID) : "";
    }

    public String getParentId() {
        return this.fConfig.getAttribute(PARENT);
    }

    public String getName() {
        return this.fConfig.getAttribute(NAME);
    }

    public ModuleCategoryDefinition getParentDefinition() {
        if (this.getParentId() != null) {
            IScriptService scriptService = ScriptService.getService();
            return scriptService.getAvailableModuleCategories().get(this.getParentId());
        }
        return null;
    }

    public String getFullName() {
        ModuleCategoryDefinition parentDefinition = this.getParentDefinition();
        if (parentDefinition != null) {
            return String.valueOf(parentDefinition.getFullName()) + "/" + this.getName();
        }
        return "/" + this.getName();
    }
}

