/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IProblemType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.CStringValue;
import org.eclipse.cdt.internal.core.dom.parser.FloatingPointValue;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPArrayType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionCall;
import org.eclipse.cdt.internal.core.parser.scanner.ExpressionEvaluator;

public class CPPASTLiteralExpression
extends ASTNode
implements ICPPASTLiteralExpression {
    private static final EvalFixed EVAL_TRUE = new EvalFixed(CPPBasicType.BOOLEAN, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(true));
    private static final EvalFixed EVAL_FALSE = new EvalFixed(CPPBasicType.BOOLEAN, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(false));
    private static final EvalFixed EVAL_NULL_PTR = new EvalFixed(CPPBasicType.NULL_PTR, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(0L));
    public static final CPPASTLiteralExpression INT_ZERO = new CPPASTLiteralExpression(0, new char[]{'0'});
    private int fKind;
    private char[] fLiteral;
    private char[] fSuffix;
    private final char[] fNumericCompilerSuffixes;
    private int fStringLiteralSize;
    private ICPPEvaluation fEvaluation;
    private IBinding fUserDefinedLiteralOperator;
    private IASTImplicitName[] fImplicitNames;
    private final boolean fUseChar8Type;

    public CPPASTLiteralExpression(int kind, char[] value) {
        this(kind, value, CharArrayUtils.EMPTY, false);
    }

    public CPPASTLiteralExpression(int kind, char[] value, boolean useChar8Type) {
        this(kind, value, CharArrayUtils.EMPTY, useChar8Type);
    }

    public CPPASTLiteralExpression(int kind, char[] value, char[] numericCompilerSuffixes, boolean useChar8Type) {
        this.fKind = kind;
        this.fSuffix = CPPASTLiteralExpression.getSuffix(kind, value, CharArrayUtils.EMPTY);
        this.fLiteral = CPPASTLiteralExpression.getLiteral(value, this.fSuffix);
        this.fNumericCompilerSuffixes = numericCompilerSuffixes == null ? CharArrayUtils.EMPTY : numericCompilerSuffixes;
        this.fStringLiteralSize = -1;
        this.fUseChar8Type = useChar8Type;
    }

    private CPPASTLiteralExpression(CPPASTLiteralExpression other) {
        this.fKind = other.fKind;
        this.fLiteral = other.fLiteral;
        this.fSuffix = other.fSuffix;
        this.fNumericCompilerSuffixes = other.fNumericCompilerSuffixes;
        this.fStringLiteralSize = other.fStringLiteralSize;
        this.fEvaluation = other.fEvaluation;
        this.fUserDefinedLiteralOperator = other.fUserDefinedLiteralOperator;
        this.fImplicitNames = other.fImplicitNames;
        this.fUseChar8Type = other.fUseChar8Type;
    }

    @Override
    public CPPASTLiteralExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTLiteralExpression copy(IASTNode.CopyStyle style) {
        return this.copy(new CPPASTLiteralExpression(this), style);
    }

    @Override
    public int getKind() {
        return this.fKind;
    }

    @Override
    public void setKind(int kind) {
        this.assertNotFrozen();
        this.set(kind, this.getValue());
    }

    @Override
    public char[] getValue() {
        return CharArrayUtils.concat(this.fLiteral, this.fSuffix);
    }

    @Override
    public void setValue(char[] value) {
        this.assertNotFrozen();
        this.set(this.fKind, value);
    }

    private void set(int kind, char[] value) {
        this.fKind = kind;
        this.fSuffix = CPPASTLiteralExpression.getSuffix(kind, value, this.fSuffix);
        this.fLiteral = CPPASTLiteralExpression.getLiteral(value, this.fSuffix);
        this.resetLazyFields();
    }

    public void setSuffix(char[] suffix) {
        this.assertNotFrozen();
        this.fSuffix = suffix == null ? CharArrayUtils.EMPTY : suffix;
        this.resetLazyFields();
    }

    private void resetLazyFields() {
        this.fStringLiteralSize = -1;
        this.fEvaluation = null;
        this.fUserDefinedLiteralOperator = null;
        this.fImplicitNames = null;
    }

    private boolean hasNumericCompilerSuffix() {
        if (this.hasNumericKind() && this.fSuffix.length == 1) {
            int j = 0;
            while (j < this.fNumericCompilerSuffixes.length) {
                if (this.fSuffix[0] == this.fNumericCompilerSuffixes[j]) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    private boolean hasNumericKind() {
        return this.fKind == 0 || this.fKind == 1;
    }

    private static char[] getLiteral(char[] value, char[] suffix) {
        if (value == null) {
            return CharArrayUtils.EMPTY;
        }
        if (suffix == null || suffix.length == 0) {
            return value;
        }
        char[] literal = CharArrayUtils.subarray(value, 0, value.length - suffix.length);
        return literal == null ? CharArrayUtils.EMPTY : literal;
    }

    private static char[] getSuffix(int kind, char[] value, char[] suffix) {
        if (value == null || value.length == 0) {
            return suffix;
        }
        int offset = 0;
        switch (kind) {
            case 0: 
            case 1: {
                try {
                    offset = value[0] == '.' ? CPPASTLiteralExpression.afterDecimalPoint(value, 0) : CPPASTLiteralExpression.integerLiteral(value);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                break;
            }
            case 3: {
                offset = CharArrayUtils.lastIndexOf('\"', value, CharArrayUtils.indexOf('\"', value) + 1) + 1;
                break;
            }
            case 2: {
                offset = CharArrayUtils.lastIndexOf('\'', value, CharArrayUtils.indexOf('\'', value) + 1) + 1;
            }
        }
        suffix = offset > 0 ? CharArrayUtils.subarray(value, offset, -1) : suffix;
        return suffix == null ? CharArrayUtils.EMPTY : suffix;
    }

    private boolean hasNumericSuffix() {
        int len = this.fSuffix.length;
        if (!this.hasSuffix() || !this.hasNumericKind() || len > 3) {
            return false;
        }
        if (len == 1) {
            switch (this.fSuffix[0]) {
                case 'F': 
                case 'L': 
                case 'U': 
                case 'f': 
                case 'l': 
                case 'u': {
                    return true;
                }
            }
        }
        if (len == 2) {
            switch (this.fSuffix[0]) {
                case 'U': 
                case 'u': {
                    return Character.toLowerCase(this.fSuffix[1]) == 'l';
                }
                case 'L': 
                case 'l': {
                    return Character.toLowerCase(this.fSuffix[1]) == 'l' || Character.toLowerCase(this.fSuffix[1]) == 'u';
                }
            }
        }
        if (len == 3) {
            switch (this.fSuffix[0]) {
                case 'U': 
                case 'u': {
                    return Character.toLowerCase(this.fSuffix[1]) == 'l' && Character.toLowerCase(this.fSuffix[2]) == 'l';
                }
                case 'L': 
                case 'l': {
                    return Character.toLowerCase(this.fSuffix[1]) == 'l' && Character.toLowerCase(this.fSuffix[2]) == 'u';
                }
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return new String(this.getValue());
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        return IASTImplicitDestructorName.EMPTY_NAME_ARRAY;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (action.shouldVisitImplicitNames) {
            IASTImplicitName[] iASTImplicitNameArray = this.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName name = iASTImplicitNameArray[n2];
                if (!name.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    private boolean hasSuffix() {
        return this.fSuffix.length > 0;
    }

    private int computeStringLiteralSize() {
        int start = 0;
        int end = this.fLiteral.length - 1;
        boolean isRaw = false;
        if (this.fLiteral[0] == 'L' || this.fLiteral[0] == 'u' || this.fLiteral[0] == 'U') {
            if (this.fLiteral[1] == '8') {
                ++start;
            }
            ++start;
        }
        if (this.fLiteral[start] == 'R') {
            ++start;
            isRaw = true;
        }
        if (this.fLiteral[start] != '\"' || this.fLiteral[end] != '\"') {
            return 0;
        }
        ++start;
        --end;
        if (isRaw) {
            while (this.fLiteral[start] != '(' && start <= end) {
                ++start;
                --end;
            }
            if (this.fLiteral[start] != '(' || this.fLiteral[end] != ')') {
                return 0;
            }
            return end - start + 1 + 1;
        }
        int length = 0;
        boolean escaping = false;
        while (start <= end) {
            if (escaping) {
                escaping = false;
                ++length;
            } else if (this.fLiteral[start] == '\\') {
                escaping = true;
            } else {
                ++length;
            }
            ++start;
        }
        return length + 1;
    }

    private IValue getStringLiteralSize() {
        if (this.fStringLiteralSize == -1) {
            this.fStringLiteralSize = this.computeStringLiteralSize();
        }
        return IntegralValue.create(this.fStringLiteralSize);
    }

    private IType getStringType() {
        IType type = new CPPBasicType(this.getBasicCharKind(), 0, this);
        type = new CPPQualifierType(type, true, false);
        return new CPPArrayType(type, this.getStringLiteralSize());
    }

    private IType getCharType() {
        return this.hasSuffix() ? this.getUserDefinedLiteralOperatorType() : new CPPBasicType(this.getBasicCharKind(), 0, this);
    }

    private IBinding getUserDefinedLiteralOperator() {
        if (this.hasSuffix() && !this.hasNumericSuffix() && this.fUserDefinedLiteralOperator == null) {
            try {
                this.fUserDefinedLiteralOperator = CPPSemantics.findUserDefinedLiteralOperator(this);
                if (this.fUserDefinedLiteralOperator instanceof IProblemBinding && this.hasNumericCompilerSuffix()) {
                    this.fUserDefinedLiteralOperator = null;
                    return null;
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
            if (this.fUserDefinedLiteralOperator == null) {
                this.fUserDefinedLiteralOperator = new ProblemBinding(this, 1, this.fSuffix);
            }
        }
        return this.fUserDefinedLiteralOperator;
    }

    private IType getUserDefinedLiteralOperatorType() {
        IBinding func = this.getUserDefinedLiteralOperator();
        if (func != null && func instanceof ICPPFunction) {
            return ((ICPPFunction)func).getType().getReturnType();
        }
        return new ProblemType(10001);
    }

    public char[] getOperatorName() {
        return CharArrayUtils.concat("operator \"\"".toCharArray(), this.fSuffix);
    }

    public IBasicType.Kind getBasicCharKind() {
        switch (this.fLiteral[0]) {
            case 'L': {
                return IBasicType.Kind.eWChar;
            }
            case 'U': {
                return IBasicType.Kind.eChar32;
            }
            case 'u': {
                if (this.fLiteral[1] == '8') {
                    if (this.fUseChar8Type) {
                        return IBasicType.Kind.eChar8;
                    }
                    return IBasicType.Kind.eChar;
                }
                return IBasicType.Kind.eChar16;
            }
        }
        return IBasicType.Kind.eChar;
    }

    private IType classifyTypeOfFloatLiteral() {
        IBasicType.Kind kind = IBasicType.Kind.eDouble;
        int flags = 0;
        if (this.hasSuffix()) {
            if (this.hasNumericSuffix()) {
                switch (this.fSuffix[0]) {
                    case 'F': 
                    case 'f': {
                        kind = IBasicType.Kind.eFloat;
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        flags |= 1;
                    }
                }
            } else {
                IType type = this.getUserDefinedLiteralOperatorType();
                if (type instanceof IProblemType && this.hasNumericCompilerSuffix()) {
                    switch (this.fSuffix[0]) {
                        case 'i': 
                        case 'j': {
                            flags |= 0x20;
                        }
                    }
                } else {
                    return type;
                }
            }
        }
        return new CPPBasicType(kind, flags, this);
    }

    private IType classifyTypeOfIntLiteral() {
        IBasicType.Kind kind = IBasicType.Kind.eInt;
        int flags = 0;
        if (this.hasSuffix()) {
            if (this.hasNumericSuffix()) {
                int makelong = 0;
                char[] cArray = this.fSuffix;
                int n = this.fSuffix.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    switch (c) {
                        case 'U': 
                        case 'u': {
                            flags |= 8;
                            break;
                        }
                        case 'L': 
                        case 'l': {
                            ++makelong;
                        }
                    }
                    ++n2;
                }
                if (makelong > 1) {
                    flags |= 0x40;
                } else if (makelong == 1) {
                    flags |= 1;
                }
            } else {
                IType type = this.getUserDefinedLiteralOperatorType();
                if (type instanceof IProblemType && this.hasNumericCompilerSuffix()) {
                    switch (this.fSuffix[0]) {
                        case 'i': 
                        case 'j': {
                            flags |= 0x20;
                        }
                    }
                } else {
                    return type;
                }
            }
        }
        return new CPPBasicType(kind, flags, this);
    }

    private static int integerLiteral(char[] value) {
        char c;
        int i = 0;
        if ((c = value[i++]) == '0' && i < value.length) {
            c = value[i];
            switch (c | 0x20) {
                case 120: {
                    return CPPASTLiteralExpression.probablyHex(value, i);
                }
                case 98: {
                    return CPPASTLiteralExpression.probablyBinary(value, i);
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    while (CPPASTLiteralExpression.isOctalOrSeparator(c) && i < value.length) {
                        c = value[++i];
                    }
                    break;
                }
                case 46: {
                    return CPPASTLiteralExpression.afterDecimalPoint(value, i);
                }
            }
            if (c == '8' || c == '9') {
                c = value[i];
                while (Character.isDigit(c) && i < value.length) {
                    c = value[++i];
                }
            }
            return CPPASTLiteralExpression.handleDecimalOrExponent(value, c, i);
        }
        if (Character.isDigit(c)) {
            c = value[i];
            while (CPPASTLiteralExpression.isDigitOrSeparator(c) && i < value.length) {
                c = value[++i];
            }
            return CPPASTLiteralExpression.handleDecimalOrExponent(value, c, i);
        }
        assert (false);
        return i;
    }

    private static int handleDecimalOrExponent(char[] value, char c, int i) {
        if (c == '.') {
            return CPPASTLiteralExpression.afterDecimalPoint(value, i);
        }
        if ((c | 0x20) == 101) {
            return CPPASTLiteralExpression.exponentPart(value, i);
        }
        return i;
    }

    private static int afterDecimalPoint(char[] value, int i) {
        char c = value[++i];
        while (CPPASTLiteralExpression.isDigitOrSeparator(c) && i < value.length) {
            c = value[++i];
        }
        if ((c | 0x20) == 101) {
            return CPPASTLiteralExpression.exponentPart(value, i);
        }
        return i;
    }

    private static int exponentPart(char[] value, int i) {
        char c;
        if ((c = value[++i]) == '+' || c == '-') {
            c = value[++i];
        }
        while (CPPASTLiteralExpression.isDigitOrSeparator(c) && i < value.length) {
            c = value[++i];
        }
        return i--;
    }

    private static int probablyBinary(char[] value, int i) {
        char c;
        if ((c = value[++i]) == '1' || c == '0') {
            while (c == '1' || c == '0' || c == '\'' && i < value.length) {
                c = value[i++];
            }
            if (Character.isDigit(c)) {
                return -1;
            }
            if (c == '.') {
                c = value[++i];
                while (CPPASTLiteralExpression.isDigitOrSeparator(c) && i < value.length) {
                    c = value[i++];
                }
            }
        } else {
            return i - 1;
        }
        return i;
    }

    private static int probablyHex(char[] value, int i) {
        char c;
        if (CPPASTLiteralExpression.isHexDigitOrSeparator(c = value[++i])) {
            while (CPPASTLiteralExpression.isHexDigitOrSeparator(c) && i < value.length) {
                c = value[++i];
            }
            if (c == '.') {
                return CPPASTLiteralExpression.hexFloatAfterDecimal(value, i);
            }
            if ((c | 0x20) == 112) {
                return CPPASTLiteralExpression.hexFloatExponent(value, i);
            }
        } else {
            return i - 1;
        }
        return i;
    }

    private static int hexFloatAfterDecimal(char[] value, int i) {
        char c;
        if (CPPASTLiteralExpression.isHexDigitOrSeparator(c = value[++i])) {
            while (CPPASTLiteralExpression.isHexDigitOrSeparator(c) && i < value.length) {
                c = value[++i];
            }
            if ((c | 0x20) == 112) {
                return CPPASTLiteralExpression.hexFloatExponent(value, i);
            }
            return -1;
        }
        return -1;
    }

    private static int hexFloatExponent(char[] value, int i) {
        char c;
        if ((c = value[++i]) == '-' || c == '+') {
            c = value[++i];
        }
        if (Character.isDigit(c)) {
            while (CPPASTLiteralExpression.isDigitOrSeparator(c) && i < value.length) {
                c = value[++i];
            }
        } else {
            return i - 1;
        }
        return i;
    }

    private static boolean isHexDigitOrSeparator(char c) {
        char lc = Character.toLowerCase(c);
        return lc <= 'f' && lc >= 'a' || c <= '9' && c >= '0' || c == '\'';
    }

    private static boolean isOctalOrSeparator(char c) {
        return c >= '0' && c <= '7' || c == '\'';
    }

    private static boolean isDigitOrSeparator(char c) {
        return Character.isDigit(c) || c == '\'';
    }

    @Override
    @Deprecated
    public void setValue(String value) {
        this.assertNotFrozen();
        this.set(this.fKind, value.toCharArray());
    }

    @Deprecated
    public CPPASTLiteralExpression(int kind, String value) {
        this(kind, value.toCharArray());
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.createEvaluation();
        }
        return this.fEvaluation;
    }

    private ICPPEvaluation createLiteralEvaluation() {
        switch (this.fKind) {
            case 4: {
                IScope scope = CPPVisitor.getContainingScope(this);
                IType type = CPPVisitor.getImpliedObjectType(scope);
                if (type == null) {
                    return EvalFixed.INCOMPLETE;
                }
                return new EvalFixed(new CPPPointerType(type), IASTExpression.ValueCategory.PRVALUE, IntegralValue.THIS);
            }
            case 5: {
                return EVAL_TRUE;
            }
            case 6: {
                return EVAL_FALSE;
            }
            case 2: {
                return new EvalFixed(this.getCharType(), IASTExpression.ValueCategory.PRVALUE, this.createCharValue());
            }
            case 1: {
                return new EvalFixed(this.classifyTypeOfFloatLiteral(), IASTExpression.ValueCategory.PRVALUE, FloatingPointValue.create(this.fLiteral));
            }
            case 0: {
                return new EvalFixed(this.classifyTypeOfIntLiteral(), IASTExpression.ValueCategory.PRVALUE, this.createIntValue());
            }
            case 3: {
                return new EvalFixed(this.getStringType(), IASTExpression.ValueCategory.LVALUE, CStringValue.create(this.fLiteral));
            }
            case 7: {
                return EVAL_NULL_PTR;
            }
        }
        return EvalFixed.INCOMPLETE;
    }

    private ICPPEvaluation createEvaluation() {
        ICPPEvaluation literalEval = this.createLiteralEvaluation();
        IBinding udlOperator = this.getUserDefinedLiteralOperator();
        if (udlOperator != null && literalEval != EvalFixed.INCOMPLETE && udlOperator instanceof ICPPFunction) {
            ICPPFunction udlOpFunction = (ICPPFunction)udlOperator;
            EvalBinding op = new EvalBinding((IBinding)udlOpFunction, (IType)udlOpFunction.getType(), this);
            ICPPEvaluation[] args = null;
            ICPPParameter[] params = udlOpFunction.getParameters();
            int paramCount = params.length;
            if (paramCount == 0) {
                args = new ICPPEvaluation[]{op};
            } else if (paramCount == 1) {
                if (params[0].getType() instanceof IPointerType) {
                    char[] numValue = this.fLiteral;
                    int numLen = numValue.length;
                    char[] strValue = new char[numLen + 2];
                    strValue[0] = 34;
                    strValue[numLen + 1] = 34;
                    System.arraycopy(numValue, 0, strValue, 1, numLen);
                    IType type = new CPPBasicType(IBasicType.Kind.eChar, 0, this);
                    type = new CPPQualifierType(type, true, false);
                    type = new CPPArrayType(type, IntegralValue.create(numLen + 1));
                    EvalFixed strEval = new EvalFixed(type, IASTExpression.ValueCategory.LVALUE, CStringValue.create(strValue));
                    args = new ICPPEvaluation[]{op, strEval};
                } else {
                    args = new ICPPEvaluation[]{op, literalEval};
                }
            } else if (paramCount == 2) {
                IntegralValue sizeValue = IntegralValue.create(this.computeStringLiteralSize() - 1);
                EvalFixed literalSizeEval = new EvalFixed(CPPBasicType.INT, IASTExpression.ValueCategory.PRVALUE, sizeValue);
                args = new ICPPEvaluation[]{op, literalEval, literalSizeEval};
            }
            return new EvalFunctionCall(args, null, this);
        }
        if (this.hasSuffix() && !this.hasNumericSuffix() && !this.hasNumericCompilerSuffix()) {
            return EvalFixed.INCOMPLETE;
        }
        return literalEval;
    }

    private IValue createCharValue() {
        try {
            int index = this.fLiteral.length > 1 && this.fLiteral[0] == 'L' ? 2 : 1;
            return IntegralValue.create(ExpressionEvaluator.getChar(this.fLiteral, index));
        }
        catch (ExpressionEvaluator.EvalException e) {
            return IntegralValue.UNKNOWN;
        }
    }

    private IValue createIntValue() {
        try {
            return IntegralValue.create(ExpressionEvaluator.getNumber(this.fLiteral));
        }
        catch (ExpressionEvaluator.EvalException e) {
            return IntegralValue.UNKNOWN;
        }
    }

    @Override
    public IType getExpressionType() {
        return CPPEvaluation.getType(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.fKind == 3 ? IASTExpression.ValueCategory.LVALUE : IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.fImplicitNames == null) {
            if (!this.hasSuffix() || this.hasNumericSuffix()) {
                this.fImplicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
            } else {
                IBinding userDefinedLiteralOperator = this.getUserDefinedLiteralOperator();
                if (userDefinedLiteralOperator == null && this.hasNumericCompilerSuffix()) {
                    this.fImplicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
                } else {
                    CPPASTImplicitName operatorName = new CPPASTImplicitName(this.fSuffix, (IASTNode)this);
                    operatorName.setOperator(true);
                    operatorName.setBinding(userDefinedLiteralOperator);
                    operatorName.setOffsetAndLength(this.getOffset() + this.fLiteral.length, this.fSuffix.length);
                    this.fImplicitNames = new IASTImplicitName[]{operatorName};
                }
            }
        }
        return this.fImplicitNames;
    }
}

