/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenStateSystemPath;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;

public class DataDrivenActionStateChange
implements DataDrivenAction {
    private final DataDrivenValue fRightOperand;
    private final DataDrivenStateSystemPath fLeftOperand;
    private final boolean fUpdate;
    private final boolean fIncrement;
    private final StackAction fStackAction;
    private final @Nullable DataDrivenValue fFutureTime;

    public DataDrivenActionStateChange(DataDrivenStateSystemPath leftOperand, DataDrivenValue rightOperand, boolean increment, boolean update, StackAction stackAction, @Nullable DataDrivenValue futureTime) {
        this.fRightOperand = rightOperand;
        this.fLeftOperand = leftOperand;
        this.fUpdate = update;
        this.fIncrement = increment;
        this.fStackAction = stackAction;
        this.fFutureTime = futureTime;
    }

    @Override
    public void eventHandle(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
        long timestamp;
        int quark = -1;
        ITmfStateSystem stateSystem = container.getStateSystem();
        if (!(stateSystem instanceof ITmfStateSystemBuilder)) {
            throw new IllegalStateException("With state changes, the state system should be in building mode");
        }
        ITmfStateSystemBuilder ssb = (ITmfStateSystemBuilder)stateSystem;
        if ((quark = this.fLeftOperand.getQuark(event, quark, scenarioInfo, container)) < 0) {
            return;
        }
        Object assignVal = this.fRightOperand.getValue(event, -1, scenarioInfo, container);
        long scTime = timestamp = event.getTimestamp().toNanos();
        if (this.fFutureTime != null) {
            Object futureTimeObj = this.fFutureTime.getValue(event, -1, scenarioInfo, container);
            if (futureTimeObj instanceof Number) {
                scTime = ((Number)futureTimeObj).longValue();
            } else {
                try {
                    scTime = Long.parseLong(String.valueOf(futureTimeObj));
                }
                catch (NumberFormatException e) {
                    try {
                        scTime = Double.valueOf(Double.parseDouble(String.valueOf(futureTimeObj))).longValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        switch (this.fStackAction) {
            case POP: {
                if (scTime > timestamp) {
                    container.addFutureState(scTime, assignVal, quark, ITmfStateProvider.FutureEventType.POP);
                } else {
                    ssb.popAttribute(timestamp, quark);
                }
                return;
            }
            case PUSH: {
                if (scTime > timestamp) {
                    container.addFutureState(scTime, assignVal, quark, ITmfStateProvider.FutureEventType.PUSH);
                } else {
                    ssb.pushAttribute(timestamp, assignVal, quark);
                }
                return;
            }
            case POP_ALL: {
                Object stackDepth = ssb.queryOngoing(quark);
                if (stackDepth instanceof Integer) {
                    int nbElements = (Integer)stackDepth;
                    int i = 0;
                    while (i < nbElements) {
                        if (scTime > timestamp) {
                            container.addFutureState(scTime, assignVal, quark, ITmfStateProvider.FutureEventType.POP);
                        } else {
                            ssb.popAttribute(timestamp, quark);
                        }
                        ++i;
                    }
                }
                return;
            }
        }
        if (this.fIncrement && assignVal != null) {
            assignVal = DataDrivenActionStateChange.incrementByType(quark, (ITmfStateSystem)ssb, assignVal);
        }
        if (this.fUpdate) {
            ssb.updateOngoingState((ITmfStateValue)TmfXmlUtils.newTmfStateValueFromObject(assignVal), quark);
        } else if (scTime == timestamp) {
            ssb.modifyAttribute(timestamp, assignVal, quark);
        } else if (scTime > timestamp) {
            container.addFutureState(scTime, assignVal, quark, ITmfStateProvider.FutureEventType.MODIFICATION);
        } else {
            Activator.logWarning("No state change occurred for event " + String.valueOf(event) + " and state change " + String.valueOf(this) + ". The time of the change is invalid: " + scTime);
        }
    }

    private static @Nullable Object incrementByType(int quark, ITmfStateSystem ss, Object stateValue) {
        if (stateValue instanceof Long) {
            Long incrementLong = (Long)stateValue;
            Object currentState = ss.queryOngoing(quark);
            Long currentValue = currentState == null ? 0L : (Long)currentState;
            return incrementLong + currentValue;
        }
        if (stateValue instanceof Integer) {
            Integer incrementLong = (Integer)stateValue;
            Object currentState = ss.queryOngoing(quark);
            Integer currentValue = currentState == null ? 0 : (Integer)currentState;
            return incrementLong + currentValue;
        }
        if (stateValue instanceof Double) {
            Double incrementLong = (Double)stateValue;
            Object currentState = ss.queryOngoing(quark);
            Double currentValue = currentState == null ? 0.0 : (Double)currentState;
            return incrementLong + currentValue;
        }
        return stateValue;
    }

    public static enum StackAction {
        NONE,
        PUSH,
        PEEK,
        POP,
        POP_ALL;


        public static StackAction getTypeFromString(String input) {
            switch (input) {
                case "push": {
                    return PUSH;
                }
                case "pop": {
                    return POP;
                }
                case "popAll": {
                    return POP_ALL;
                }
                case "peek": {
                    return PEEK;
                }
            }
            return NONE;
        }
    }
}

