/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPFunctionSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;

public class FunctionSetType
implements IType {
    private final CPPFunctionSet fFunctionSet;
    private final boolean fPointerType;

    public FunctionSetType(CPPFunctionSet set, boolean addressOf) {
        this.fFunctionSet = set;
        this.fPointerType = addressOf;
    }

    @Override
    public boolean isSameType(IType type) {
        return type instanceof FunctionSetType && this.fFunctionSet == ((FunctionSetType)type).fFunctionSet;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public IASTExpression.ValueCategory getValueCategory() {
        return this.fPointerType ? IASTExpression.ValueCategory.PRVALUE : IASTExpression.ValueCategory.LVALUE;
    }

    public Cost costForTarget(IType paramType) {
        ICPPFunction result = CPPSemantics.resolveTargetedFunction(paramType, this.fFunctionSet);
        if (result instanceof ICPPFunction && !(result instanceof IProblemBinding)) {
            Cost c = new Cost(paramType, paramType, Cost.Rank.IDENTITY);
            c.setSelectedFunction(result);
            return c;
        }
        return Cost.NO_CONVERSION;
    }

    public void applySelectedFunction(ICPPFunction selectedFunction) {
        this.fFunctionSet.applySelectedFunction(selectedFunction);
    }

    public CPPFunctionSet getFunctionSet() {
        return this.fFunctionSet;
    }

    public void setToUnknown() {
        this.fFunctionSet.setToUnknown();
    }
}

