/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.modules.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.ui.modules.ui.ModulePopupItem;
import org.eclipse.ease.ui.modules.ui.ModulePopupMenu;
import org.eclipse.ease.ui.tools.AbstractPopupItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.service.prefs.Preferences;

public final class ModuleContributionFactory
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator fServiceLocator;

    public void initialize(IServiceLocator serviceLocator) {
        this.fServiceLocator = serviceLocator;
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<IContributionItem> contributions = new ArrayList<IContributionItem>();
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        Collection modules = scriptService.getAvailableModules();
        Preferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui").node("shell");
        boolean flatMode = prefs.getBoolean("shellModulesAsList", false);
        HashMap<IPath, ModulePopupMenu> moduleTree = new HashMap<IPath, ModulePopupMenu>();
        ModulePopupMenu menu = new ModulePopupMenu("");
        moduleTree.put((IPath)new Path("/"), menu);
        for (ModuleDefinition definition : modules) {
            if (!definition.isVisible()) continue;
            if (!flatMode) {
                IPath path = definition.getPath();
                if (!moduleTree.containsKey(path.removeLastSegments(1))) {
                    ModuleContributionFactory.createPath(moduleTree, path.removeLastSegments(1));
                }
                menu = moduleTree.get(path.removeLastSegments(1));
            }
            menu.addEntry(new ModulePopupItem(definition));
        }
        for (ModulePopupMenu popupMenu : moduleTree.values()) {
            popupMenu.sortEntries();
        }
        ModulePopupMenu root = (ModulePopupMenu)moduleTree.get(new Path("/"));
        for (AbstractPopupItem item : root.getEntries()) {
            contributions.add(item.getContribution(this.fServiceLocator));
        }
        return contributions.toArray(new IContributionItem[contributions.size()]);
    }

    public boolean isDirty() {
        return true;
    }

    private static ModulePopupMenu createPath(Map<IPath, ModulePopupMenu> moduleTree, IPath path) {
        if (!moduleTree.containsKey(path)) {
            ModulePopupMenu parentMenu = ModuleContributionFactory.createPath(moduleTree, path.removeLastSegments(1));
            ModulePopupMenu menu = new ModulePopupMenu(path.lastSegment());
            parentMenu.addEntry(menu);
            moduleTree.put(path, menu);
            return menu;
        }
        return moduleTree.get(path);
    }
}

