/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.ui.views.contextswitch;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

@NonNullByDefault
public class ContextSwitchEntry
extends TimeGraphEntry {
    private static final int NO_ID = -666;
    private final int fId;
    private final ITmfTrace fTrace;
    private double fMean;

    public ContextSwitchEntry(ITmfTrace trace, long startTime, long endTime) {
        this(trace, String.valueOf(trace.getName()), startTime, endTime, -666);
    }

    public ContextSwitchEntry(ITmfTrace trace, String name, long startTime, long endTime, int id) {
        super(name, startTime, endTime);
        this.fId = id;
        this.fTrace = trace;
    }

    public int getId() {
        return this.fId;
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public boolean hasId() {
        return this.fId != -666;
    }

    public double getMean() {
        return this.fMean;
    }

    void setMean(double mean) {
        this.fMean = mean;
        for (TimeGraphEntry child : this.getChildren()) {
            if (!(child instanceof ContextSwitchEntry)) continue;
            ((ContextSwitchEntry)child).setMean(mean);
        }
    }
}

