/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.RemedyElementCategory;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.Remedy;
import org.eclipse.equinox.p2.operations.RemedyIUDetail;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class ElementUtils {
    public static void updateRepositoryUsingElements(ProvisioningUI ui, MetadataRepositoryElement[] elements) {
        ui.signalRepositoryOperationStart();
        IMetadataRepositoryManager metaManager = ProvUI.getMetadataRepositoryManager(ui.getSession());
        IArtifactRepositoryManager artManager = ProvUI.getArtifactRepositoryManager(ui.getSession());
        try {
            int visibilityFlags = ui.getRepositoryTracker().getMetadataRepositoryFlags();
            URI[] currentlyEnabled = metaManager.getKnownRepositories(visibilityFlags);
            URI[] currentlyDisabled = metaManager.getKnownRepositories(8 | visibilityFlags);
            MetadataRepositoryElement[] metadataRepositoryElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                MetadataRepositoryElement element = metadataRepositoryElementArray[n2];
                URI location = element.getLocation();
                if (element.isEnabled()) {
                    if (ElementUtils.containsURI(currentlyDisabled, location)) {
                        ElementUtils.setColocatedRepositoryEnablement(ui, location, true);
                    } else if (!ElementUtils.containsURI(currentlyEnabled, location)) {
                        metaManager.addRepository(location);
                        artManager.addRepository(location);
                        metaManager.setRepositoryProperty(location, "p2.system", "false");
                        artManager.setRepositoryProperty(location, "p2.system", "false");
                    }
                } else if (ElementUtils.containsURI(currentlyEnabled, location)) {
                    ElementUtils.setColocatedRepositoryEnablement(ui, location, false);
                } else if (!ElementUtils.containsURI(currentlyDisabled, location)) {
                    metaManager.addRepository(location);
                    artManager.addRepository(location);
                    ElementUtils.setColocatedRepositoryEnablement(ui, location, false);
                }
                String name = element.getName();
                if (name != null && name.length() > 0) {
                    metaManager.setRepositoryProperty(location, "p2.nickname", name);
                    artManager.setRepositoryProperty(location, "p2.nickname", name);
                }
                ++n2;
            }
            HashSet<String> nowKnown = new HashSet<String>();
            Object[] objectArray = elements;
            int n3 = elements.length;
            n = 0;
            while (n < n3) {
                MetadataRepositoryElement element = objectArray[n];
                nowKnown.add(URIUtil.toUnencodedString((URI)element.getLocation()));
                ++n;
            }
            objectArray = currentlyEnabled;
            n3 = currentlyEnabled.length;
            n = 0;
            while (n < n3) {
                Object element = objectArray[n];
                if (!nowKnown.contains(URIUtil.toUnencodedString((URI)element))) {
                    metaManager.removeRepository((URI)element);
                    artManager.removeRepository((URI)element);
                }
                ++n;
            }
            objectArray = currentlyDisabled;
            n3 = currentlyDisabled.length;
            n = 0;
            while (n < n3) {
                Object element = objectArray[n];
                if (!nowKnown.contains(URIUtil.toUnencodedString((URI)element))) {
                    metaManager.removeRepository((URI)element);
                    artManager.removeRepository((URI)element);
                }
                ++n;
            }
        }
        finally {
            ui.signalRepositoryOperationComplete(null, true);
        }
    }

    private static void setColocatedRepositoryEnablement(ProvisioningUI ui, URI location, boolean enable) {
        ProvUI.getArtifactRepositoryManager(ui.getSession()).setEnabled(location, enable);
        ProvUI.getMetadataRepositoryManager(ui.getSession()).setEnabled(location, enable);
    }

    public static IInstallableUnit getIU(Object element) {
        if (element instanceof IInstallableUnit) {
            return (IInstallableUnit)element;
        }
        if (element instanceof IIUElement) {
            return ((IIUElement)element).getIU();
        }
        return ProvUI.getAdapter(element, IInstallableUnit.class);
    }

    public static List<IInstallableUnit> elementsToIUs(Object[] elements) {
        ArrayList<IInstallableUnit> theIUs = new ArrayList<IInstallableUnit>(elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IInstallableUnit iu = ProvUI.getAdapter(element, IInstallableUnit.class);
            if (iu != null) {
                theIUs.add(iu);
            }
            ++n2;
        }
        return theIUs;
    }

    public static IInstallableUnit elementToIU(Object selectedElement) {
        return ProvUI.getAdapter(selectedElement, IInstallableUnit.class);
    }

    static boolean containsURI(URI[] locations, URI url) {
        URI[] uRIArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            URI location = uRIArray[n2];
            if (location.equals(url)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static AvailableIUElement[] requestToElement(Remedy remedy, boolean installMode) {
        if (remedy == null) {
            return new AvailableIUElement[0];
        }
        ArrayList<AvailableIUElement> temp = new ArrayList<AvailableIUElement>();
        ProvisioningUI ui = ProvisioningUI.getDefaultUI();
        IUElementListRoot root = new IUElementListRoot(ui);
        for (RemedyIUDetail iuDetail : remedy.getIusDetails()) {
            if (iuDetail.getStatus() == 3) continue;
            AvailableIUElement element = new AvailableIUElement(root, iuDetail.getIu(), ui.getProfileId(), true);
            if (iuDetail.getBeingInstalledVersion() != null && iuDetail.getRequestedVersion() != null && iuDetail.getBeingInstalledVersion().compareTo((Object)iuDetail.getRequestedVersion()) < 0 && !installMode) {
                element.setImageOverlayId("obj/iu_info.png");
            } else if (iuDetail.getStatus() == 2) {
                element.setImageId("obj/iu_remove.png");
            }
            temp.add(element);
        }
        return temp.toArray(new AvailableIUElement[temp.size()]);
    }

    public static RemedyElementCategory[] requestToRemedyElementsCategories(Remedy remedy) {
        ArrayList<RemedyElementCategory> categories = new ArrayList<RemedyElementCategory>();
        RemedyElementCategory categoryAdded = new RemedyElementCategory(ProvUIMessages.RemedyCategoryAdded);
        RemedyElementCategory cateogyRemoved = new RemedyElementCategory(ProvUIMessages.RemedyCategoryRemoved);
        RemedyElementCategory categoryNotAdded = new RemedyElementCategory(ProvUIMessages.RemedyCategoryNotAdded);
        RemedyElementCategory categoryChanged = new RemedyElementCategory(ProvUIMessages.RemedyCategoryChanged);
        for (RemedyIUDetail remedyIUVersions : remedy.getIusDetails()) {
            if (remedyIUVersions.getStatus() == 1) {
                categoryAdded.add(remedyIUVersions);
                continue;
            }
            if (remedyIUVersions.getStatus() == 4) {
                categoryChanged.add(remedyIUVersions);
                continue;
            }
            if (remedyIUVersions.getStatus() == 2) {
                cateogyRemoved.add(remedyIUVersions);
                continue;
            }
            if (remedyIUVersions.getStatus() != 3) continue;
            categoryNotAdded.add(remedyIUVersions);
        }
        if (cateogyRemoved.getElements().size() > 0) {
            categories.add(cateogyRemoved);
        }
        if (categoryChanged.getElements().size() > 0) {
            categories.add(categoryChanged);
        }
        if (categoryNotAdded.getElements().size() > 0) {
            categories.add(categoryNotAdded);
        }
        if (categoryAdded.getElements().size() > 0) {
            categories.add(categoryAdded);
        }
        return categories.toArray(new RemedyElementCategory[categories.size()]);
    }
}

