/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.trace.layout;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.incubator.internal.ros2.core.trace.layout.Ros2RollingEventLayout;

@NonNullByDefault
public interface IRos2EventLayout {
    public static final String PROVIDER_NAME = "ros2:";
    public static final String DDS_PROVIDER_NAME = "dds:";
    public static final String TRACETOOLS_VERSION_UNKNOWN = "0.0.0";

    public static IRos2EventLayout getDefault() {
        return Ros2RollingEventLayout.getInstance();
    }

    default public String getProviderName() {
        return PROVIDER_NAME;
    }

    default public Collection<String> getEventNames() {
        ArrayList eventNames = Lists.newArrayList();
        Iterables.filter(Arrays.asList(IRos2EventLayout.class.getMethods()), method -> method.getName().startsWith("event")).forEach(eventMethod -> {
            try {
                eventNames.add(Objects.requireNonNull((String)eventMethod.invoke((Object)this, new Object[0])));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        });
        return ImmutableList.copyOf((Collection)Objects.requireNonNull(eventNames));
    }

    public String eventRclInit();

    public String eventRclNodeInit();

    public String eventRmwPublisherInit();

    public String eventRclPublisherInit();

    public String eventRclcppPublish();

    public String eventRclPublish();

    public String eventRmwPublish();

    public String eventRmwSubscriptionInit();

    public String eventRclSubscriptionInit();

    public String eventRclcppSubscriptionInit();

    public String eventRclcppSubscriptionCallbackAdded();

    public String eventRmwTake();

    public String eventRclTake();

    public String eventRclcppTake();

    public String eventRclServiceInit();

    public String eventRclcppServiceCallbackAdded();

    public String eventRmwTakeRequest();

    public String eventRmwSendResponse();

    public String eventRmwClientInit();

    public String eventRclClientInit();

    public String eventRmwSendRequest();

    public String eventRmwTakeResponse();

    public String eventRclTimerInit();

    public String eventRclcppTimerCallbackAdded();

    public String eventRclcppTimerLinkNode();

    public String eventRclcppCallbackRegister();

    public String eventCallbackStart();

    public String eventCallbackEnd();

    public String eventRclLifecycleStateMachineInit();

    public String eventRclLifecycleTransition();

    public String eventRclcppExecutorGetNextReady();

    public String eventRclcppExecutorWaitForWork();

    public String eventRclcppExecutorExecute();

    public String eventMessageLinkPeriodicAsync();

    public String eventMessageLinkPartialSync();

    public String eventDdsCreateWriter();

    public String eventDdsWritePre();

    public String eventDdsWrite();

    public String eventDdsCreateReader();

    public String eventDdsRead();

    public String fieldContextHandle();

    public String fieldVersion();

    public String fieldNodeHandle();

    public String fieldRmwHandle();

    public String fieldNodeName();

    public String fieldNamespace();

    public String fieldRmwPublisherHandle();

    public String fieldGid();

    public String fieldPublisherHandle();

    public String fieldTopicName();

    public String fieldQueueDepth();

    public String fieldMessage();

    public String fieldRmwSubscriptionHandle();

    public String fieldSubscriptionHandle();

    public String fieldSubscription();

    public String fieldCallback();

    public String fieldSourceTimestamp();

    public String fieldTaken();

    public String fieldServiceHandle();

    public String fieldRmwServiceHandle();

    public String fieldServiceName();

    public String fieldClientHandle();

    public String fieldRmwClientHandle();

    public String fieldRequest();

    public String fieldClientGid();

    public String fieldSequenceNumber();

    public String fieldResponse();

    public String fieldTimerHandle();

    public String fieldPeriod();

    public String fieldSymbol();

    public String fieldIsIntraProcess();

    public String fieldStateMachine();

    public String fieldStartLabel();

    public String fieldGoalLabel();

    public String fieldTimeout();

    public String fieldHandle();

    public String fieldSubs();

    public String fieldPubs();

    public String fieldGidPrefix();

    public String fieldGidEntity();

    public String fieldWriter();

    public String fieldData();

    public String fieldTimestamp();

    public String fieldReader();

    public String fieldBuffer();

    public String contextVpid();

    public String contextVtid();

    public String contextProcname();

    public String contextPerfThreadTaskClock();
}

