/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.search;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.util.ResourceLocator;
import org.eclipse.help.search.IHelpSearchIndex;
import org.eclipse.help.search.ISearchDocument;
import org.osgi.framework.Bundle;

public abstract class SearchParticipant {
    private static final HashSet<String> EMPTY_SET = new HashSet();
    private String id;

    public final void init(String id) {
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    public abstract IStatus addDocument(IHelpSearchIndex var1, String var2, String var3, URL var4, String var5, ISearchDocument var6);

    public Set<String> getAllDocuments(String locale) {
        return EMPTY_SET;
    }

    public Set<String> getContributingPlugins() {
        return EMPTY_SET;
    }

    protected static String resolveVariables(String pluginId, String fileName, String locale) {
        if (fileName.indexOf(36) == -1) {
            return fileName;
        }
        ArrayList prefix = ResourceLocator.getPathPrefix((String)locale);
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return fileName;
        }
        URL url = ResourceLocator.find((Bundle)bundle, (IPath)IPath.fromOSString((String)fileName), (ArrayList)prefix);
        URL root = FileLocator.find((Bundle)bundle, (IPath)IPath.EMPTY, null);
        return url.toString().substring(root.toString().length());
    }

    protected void addTitle(String title, ISearchDocument doc) {
        doc.setTitle(title);
    }

    public boolean open(String id) {
        return false;
    }

    public void clear() {
    }
}

