/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.types;

import com.google.common.base.Objects;
import java.nio.charset.Charset;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition2;

public class StaticLengthStringDeclaration
extends Declaration {
    private final Charset fEncoding;
    private final int fLength;

    public StaticLengthStringDeclaration(int length, Charset encoding) {
        this.fLength = length;
        this.fEncoding = encoding;
    }

    public Charset getEncoding() {
        return this.fEncoding;
    }

    public int getLength() {
        return this.fLength;
    }

    @Override
    public StringDefinition2 createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        long rawLength = this.fLength;
        if (rawLength < 0L) {
            throw new CTFException("Cannot have a length < 0, declared = " + rawLength);
        }
        if ((double)rawLength > 1000000.0) {
            throw new CTFException("Cannot have a length > 1000000, declared = " + rawLength);
        }
        int length = (int)rawLength;
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < length) {
            bytes[i] = (byte)input.get(8, false);
            ++i;
        }
        String value = new String(bytes, this.fEncoding);
        int nullIndex = value.indexOf(0);
        if (nullIndex >= 0) {
            value = value.substring(0, nullIndex);
        }
        return new StringDefinition2(this, definitionScope, fieldName, value);
    }

    @Override
    public long getAlignment() {
        return 8L;
    }

    @Override
    public int getMaximumSize() {
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return "static_string[" + this.fLength + "]<" + this.fEncoding.name() + ">";
    }

    @Override
    public boolean isBinaryEquivalent(IDeclaration other) {
        if (!(other instanceof StaticLengthStringDeclaration)) {
            return false;
        }
        StaticLengthStringDeclaration o = (StaticLengthStringDeclaration)other;
        return this.fLength == o.fLength && Objects.equal((Object)this.fEncoding, (Object)o.fEncoding);
    }
}

