/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.local.showin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.tcf.te.ui.terminals.interfaces.ILauncherDelegate;
import org.eclipse.tcf.te.ui.terminals.launcher.LauncherDelegateManager;
import org.eclipse.tcf.te.ui.terminals.local.showin.ExternalExecutablesManager;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class DynamicContributionItems
extends CompoundContributionItem
implements IWorkbenchContribution {
    protected IServiceLocator serviceLocator;
    ILauncherDelegate delegate;

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
        this.delegate = LauncherDelegateManager.getInstance().getLauncherDelegate("org.eclipse.tcf.te.ui.terminals.local.launcher.local", false);
    }

    protected IContributionItem[] getContributionItems() {
        List<Map<String, String>> l;
        ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
        if (this.delegate != null && (l = ExternalExecutablesManager.load()) != null && !l.isEmpty()) {
            for (Map<String, String> executableData : l) {
                ImageDescriptor desc;
                ImageData id;
                boolean translate;
                String name = executableData.get("Name");
                String path = executableData.get("Path");
                String args = executableData.get("Args");
                String icon = executableData.get("Icon");
                String strTranslate = executableData.get("Translate");
                boolean bl = translate = strTranslate != null ? Boolean.parseBoolean(strTranslate) : false;
                if (name == null || "".equals(name) || path == null || "".equals(path)) continue;
                IAction action = this.createAction(name, path, args, translate);
                ImageData imageData = id = icon != null ? ExternalExecutablesManager.loadImage(icon) : null;
                if (id != null && (desc = ImageDescriptor.createFromImageData((ImageData)id)) != null) {
                    action.setImageDescriptor(desc);
                }
                ActionContributionItem item = new ActionContributionItem(action);
                items.add(item);
            }
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    protected IAction createAction(String label, final String path, final String args, final boolean translate) {
        Assert.isNotNull((Object)label);
        Assert.isNotNull((Object)path);
        Action action = new Action(label){

            public void run() {
                ISelection selection;
                Assert.isNotNull((Object)DynamicContributionItems.this.delegate);
                ISelectionService service = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
                ISelection iSelection = selection = service != null ? service.getSelection() : null;
                if (selection != null && selection.isEmpty()) {
                    selection = null;
                }
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("delegateId", DynamicContributionItems.this.delegate.getId());
                if (selection != null) {
                    properties.put("selection", selection);
                }
                properties.put("process.path", path);
                if (args != null) {
                    properties.put("process.args", args);
                }
                properties.put("translateBackslashesOnPaste", translate);
                DynamicContributionItems.this.delegate.execute(properties, null);
            }
        };
        return action;
    }
}

