/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.model;

import org.eclipse.tcf.te.runtime.model.ModelNode;
import org.eclipse.tcf.te.runtime.model.activator.CoreBundleActivator;

public class MessageModelNode
extends ModelNode {
    public static final String PROPERTY_SEVERITY = "severity";
    public static final int PENDING = 255;
    public static final String OBJECT_MESSAGE_PENDING_ID = String.valueOf(CoreBundleActivator.getUniqueIdentifier()) + ".message.pending";
    public static final String OBJECT_MESSAGE_INFO_ID = String.valueOf(CoreBundleActivator.getUniqueIdentifier()) + ".message.info";
    public static final String OBJECT_MESSAGE_WARNING_ID = String.valueOf(CoreBundleActivator.getUniqueIdentifier()) + ".message.warning";
    public static final String OBJECT_MESSAGE_ERROR_ID = String.valueOf(CoreBundleActivator.getUniqueIdentifier()) + ".message.error";
    private boolean locked = false;

    public MessageModelNode(String message, int severity, boolean locked) {
        this.setProperty("name", message);
        this.setProperty(PROPERTY_SEVERITY, severity);
        this.locked = locked;
    }

    public boolean setProperty(String key, Object value) {
        if (this.locked) {
            return false;
        }
        return super.setProperty(key, value);
    }

    @Override
    public String getImageId() {
        switch (this.getIntProperty(PROPERTY_SEVERITY)) {
            case 255: {
                return OBJECT_MESSAGE_PENDING_ID;
            }
            case 1: {
                return OBJECT_MESSAGE_INFO_ID;
            }
            case 2: {
                return OBJECT_MESSAGE_WARNING_ID;
            }
            case 4: {
                return OBJECT_MESSAGE_ERROR_ID;
            }
        }
        return null;
    }
}

