/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.controls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.controls.panels.AbstractWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.controls.validator.RegexValidator;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode3;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PipeTransportPanel
extends AbstractWizardConfigurationPanel
implements IDataExchangeNode3 {
    private PipeNameControl pipeNameControl;

    public PipeTransportPanel(BaseDialogPageControl parentControl) {
        super(parentControl);
    }

    public void dispose() {
        if (this.pipeNameControl != null) {
            this.pipeNameControl.dispose();
            this.pipeNameControl = null;
        }
        super.dispose();
    }

    protected boolean isAdjustBackgroundColor() {
        return this.getParentControl().getParentPage() != null;
    }

    public void setupPanel(Composite parent, FormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        boolean adjustBackgroundColor = this.isAdjustBackgroundColor();
        Composite panel = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (adjustBackgroundColor) {
            panel.setBackground(parent.getBackground());
        }
        this.setControl(panel);
        this.pipeNameControl = this.doCreatePipeNameControl(this.getParentControl().getParentPage());
        this.pipeNameControl.setFormToolkit(toolkit);
        this.pipeNameControl.setupPanel(panel);
    }

    protected PipeNameControl doCreatePipeNameControl(IDialogPage parentPage) {
        return new PipeNameControl(parentPage);
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        if (!valid) {
            return false;
        }
        if (this.pipeNameControl != null) {
            valid = this.pipeNameControl.isValid();
            this.setMessage(this.pipeNameControl.getMessage(), this.pipeNameControl.getMessageType());
        }
        return valid;
    }

    public boolean dataChanged(IPropertiesContainer data, TypedEvent e) {
        String pipeName;
        Assert.isNotNull((Object)data);
        boolean isDirty = false;
        if (this.pipeNameControl != null && (pipeName = this.pipeNameControl.getEditFieldControlText()) != null) {
            isDirty |= !pipeName.equals(data.getStringProperty("PipeName"));
        }
        return isDirty;
    }

    public void setupData(IPropertiesContainer data) {
        if (data == null) {
            return;
        }
        if (this.pipeNameControl != null) {
            this.pipeNameControl.setEditFieldControlText(data.getStringProperty("PipeName"));
        }
    }

    public void extractData(IPropertiesContainer data) {
        if (data == null) {
            return;
        }
        if (this.pipeNameControl != null) {
            String pipeName = this.pipeNameControl.getEditFieldControlText();
            data.setProperty("PipeName", (Object)(!"".equals(pipeName) ? pipeName : null));
        }
    }

    public void initializeData(IPropertiesContainer data) {
    }

    public void removeData(IPropertiesContainer data) {
        if (data == null) {
            return;
        }
        data.setProperty("PipeName", null);
    }

    public void copyData(IPropertiesContainer src, IPropertiesContainer dst) {
        Assert.isNotNull((Object)src);
        Assert.isNotNull((Object)dst);
        dst.setProperty("PipeName", src.getProperty("PipeName"));
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        super.doSaveWidgetValues(settings, idPrefix);
        if (this.pipeNameControl != null) {
            this.pipeNameControl.doSaveWidgetValues(settings, idPrefix);
        }
    }

    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        super.doRestoreWidgetValues(settings, idPrefix);
        if (this.pipeNameControl != null) {
            this.pipeNameControl.doRestoreWidgetValues(settings, idPrefix);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.pipeNameControl != null) {
            SWTControlUtil.setEnabled((Control)this.pipeNameControl.getEditFieldControl(), (boolean)enabled);
        }
    }

    protected class PipeNameControl
    extends BaseEditBrowseTextControl {
        public PipeNameControl(IDialogPage parentPage) {
            super(parentPage);
            this.setIsGroup(false);
            this.setHasHistory(false);
            this.setHideBrowseButton(true);
            this.setEditFieldLabel(Messages.PipeNameControl_label);
        }

        protected Validator doCreateEditFieldValidator() {
            return new RegexValidator(1, ".*");
        }

        protected void configureEditFieldValidator(Validator validator) {
            if (validator instanceof RegexValidator) {
                validator.setMessageText("RegexValidator_Information_MissingValue", Messages.PipeNameControl_information_missingValue);
                validator.setMessageText("RegexValidator_Error_InvalidValue", Messages.PipeNameControl_error_invalidValue);
            }
        }

        public IValidatingContainer getValidatingContainer() {
            return PipeTransportPanel.this.getParentControl().getValidatingContainer();
        }

        public void modifyText(ModifyEvent e) {
            super.modifyText(e);
            if (PipeTransportPanel.this.getParentControl() instanceof ModifyListener) {
                ((ModifyListener)PipeTransportPanel.this.getParentControl()).modifyText(e);
            }
        }
    }
}

