/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.celleditor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Item;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;

public class FSCellModifier
implements ICellModifier {
    public static final String PROPERTY_NAME = "name";

    public boolean canModify(Object element, String property) {
        if (property.equals(PROPERTY_NAME)) {
            IFSTreeNode node;
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (element instanceof IFSTreeNode && !(node = (IFSTreeNode)element).isRootDirectory()) {
                return node.isWindowsNode() && !node.isReadOnly() || !node.isWindowsNode() && node.isWritable();
            }
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        if (property.equals(PROPERTY_NAME)) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (element instanceof IFSTreeNode) {
                IFSTreeNode node = (IFSTreeNode)element;
                return node.getName();
            }
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        if (property.equals(PROPERTY_NAME)) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (element instanceof IFSTreeNode) {
                IFSTreeNode node = (IFSTreeNode)element;
                Assert.isTrue((value != null && value instanceof String ? 1 : 0) != 0);
                String newName = (String)value;
                UiExecutor.execute(node.operationRename(newName));
            }
        }
    }
}

