/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;

public class DialogSettingsUtil {
    public static final int COMBO_HISTORY_LENGTH = 5;
    public static final String[] NO_ELEMENTS = new String[0];

    public static String[] addToHistory(String[] history, String newEntry) {
        Assert.isNotNull((Object)history);
        ArrayList<String> historyList = new ArrayList<String>(Arrays.asList(history));
        DialogSettingsUtil.addToHistory(historyList, newEntry);
        history = historyList.toArray(new String[historyList.size()]);
        return history;
    }

    private static void addToHistory(List<String> history, String newEntry) {
        if (newEntry != null && newEntry.trim().length() > 0) {
            StringBuffer entry = new StringBuffer(newEntry);
            while (entry.length() > 0) {
                history.remove(entry.toString());
                entry.deleteCharAt(entry.length() - 1);
            }
            history.add(0, newEntry);
            if (history.size() > 5) {
                history.remove(5);
            }
        }
    }

    public static String[] getSettingsArraySafe(IDialogSettings settings, String key) {
        Assert.isNotNull((Object)settings);
        Assert.isNotNull((Object)key);
        String[] result = null;
        String[] values = settings.getArray(key);
        if (values != null && values.length > 0) {
            boolean filtered = false;
            ArrayList<String> filteredValue = new ArrayList<String>(values.length);
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (value != null && value.trim().length() > 0) {
                    filteredValue.add(value);
                } else {
                    filtered = true;
                }
                ++n2;
            }
            if (filtered) {
                if (!filteredValue.isEmpty()) {
                    result = filteredValue.toArray(new String[filteredValue.size()]);
                }
            } else {
                result = values;
            }
        }
        return result != null ? result : NO_ELEMENTS;
    }
}

