/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.core.delegates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.core.interfaces.IPathMapGeneratorService;
import org.eclipse.tcf.te.tcf.core.interfaces.IPathMapService;
import org.eclipse.tcf.te.tcf.launch.core.internal.services.PathMapService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;

public final class Launch
extends TCFLaunch {
    private ICallback callback = null;
    private boolean manualDisconnected = false;
    private final IPropertiesContainer properties = new PropertiesContainer(){

        public Object getAdapter(Class adapter) {
            if (ILaunch.class.equals((Object)adapter)) {
                return Launch.this;
            }
            return super.getAdapter(adapter);
        }
    };

    public Launch(ILaunchConfiguration configuration, String mode) {
        super(configuration, mode);
    }

    public void setCallback(ICallback callback) {
        this.callback = callback;
    }

    public ICallback getCallback() {
        return this.callback;
    }

    public void attachDebugger(IPeerNode node, final ICallback callback) {
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)callback);
        this.manualDisconnected = false;
        this.properties.setProperty("node", (Object)node);
        final String name = node.getName();
        HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
        flags.put("channel.forceNew", Boolean.TRUE);
        Tcf.getChannelManager().openChannel(node.getPeer(), flags, new IChannelManager.DoneOpenChannel(){

            public void doneOpenChannel(Throwable error, IChannel channel) {
                if (error == null && channel != null) {
                    TCFLaunch.LaunchListener listener = new TCFLaunch.LaunchListener(){

                        public void onProcessStreamError(TCFLaunch launch, String process_id, int stream_id, Exception error, int lost_size) {
                        }

                        public void onProcessOutput(TCFLaunch launch, String process_id, int stream_id, byte[] data) {
                        }

                        public void onDisconnected(TCFLaunch launch) {
                            callback.done((Object)Launch.this, StatusHelper.getStatus((Throwable)Launch.this.getError()));
                            Launch.removeListener((TCFLaunch.LaunchListener)this);
                        }

                        public void onCreated(TCFLaunch launch) {
                        }

                        public void onConnected(TCFLaunch launch) {
                            callback.done((Object)Launch.this, Status.OK_STATUS);
                            Launch.removeListener((TCFLaunch.LaunchListener)this);
                        }
                    };
                    Launch.addListener((TCFLaunch.LaunchListener)listener);
                    Launch.this.launchTCF(Launch.this.getLaunchMode(), name, channel);
                } else {
                    callback.done((Object)Launch.this, StatusHelper.getStatus((Throwable)error));
                }
            }
        });
    }

    public boolean isManualDisconnected() {
        return this.manualDisconnected;
    }

    public void disconnect() throws DebugException {
        this.manualDisconnected = true;
        super.disconnect();
    }

    protected String getPeerName(IPeer peer) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)peer);
        IPeerNode node = (IPeerNode)this.properties.getProperty("node");
        return node != null ? node.getName() : super.getPeerName(peer);
    }

    private Collection<IPathMap.PathMapRule> readCustomPathMapConfiguration() {
        IPathMap.PathMapRule[] generatedRules;
        IPeerNode node = (IPeerNode)this.properties.getProperty("node");
        IPeer peer = node != null ? node.getPeer() : this.getChannel().getRemotePeer();
        ArrayList<IPathMap.PathMapRule> list = new ArrayList<IPathMap.PathMapRule>();
        IPathMapGeneratorService generator = (IPathMapGeneratorService)ServiceManager.getInstance().getService((Object)peer, IPathMapGeneratorService.class);
        if (generator != null && (generatedRules = generator.getPathMap((Object)peer)) != null && generatedRules.length > 0) {
            IPathMap.PathMapRule[] pathMapRuleArray = generatedRules;
            int n = generatedRules.length;
            int n2 = 0;
            while (n2 < n) {
                IPathMap.PathMapRule rule = pathMapRuleArray[n2];
                list.add(rule);
                ++n2;
            }
        }
        return list;
    }

    protected void applyPathMap(final Runnable done) {
        final List configuredMap = this.getHostPathMap();
        configuredMap.addAll(this.readCustomPathMapConfiguration());
        int cnt = 0;
        String id = this.getClientID();
        for (IPathMap.PathMapRule r : configuredMap) {
            r.getProperties().put("ID", String.valueOf(id) + "/" + cnt++);
        }
        final String clientID = this.getClientID();
        if (clientID != null) {
            final IPathMap svc = (IPathMap)this.getService(IPathMap.class);
            if (svc != null) {
                svc.get(new IPathMap.DoneGet(){

                    public void doneGet(IToken token, Exception error, IPathMap.PathMapRule[] map) {
                        List<IPathMap.PathMapRule> rules = PathMapService.mergePathMaps(clientID, map, configuredMap.toArray(new IPathMap.PathMapRule[configuredMap.size()]));
                        if (PathMapService.isDifferent(rules, map)) {
                            PathMapService.set(rules, svc, false, new IPathMap.DoneSet(){

                                public void doneSet(IToken token, Exception error) {
                                    if (error != null) {
                                        Launch.this.getChannel().terminate((Throwable)error);
                                    } else if (done != null) {
                                        done.run();
                                    }
                                }
                            });
                        } else if (done != null) {
                            done.run();
                        }
                    }
                });
            } else if (done != null) {
                done.run();
            }
        } else {
            super.applyPathMap(done);
        }
    }

    public Object getAdapter(Class adapter) {
        if (IPropertiesContainer.class.equals((Object)adapter)) {
            return this.properties;
        }
        Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        return super.getAdapter(adapter);
    }

    public void launchConfigurationChanged(ILaunchConfiguration cfg) {
        super.launchConfigurationChanged(cfg);
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                IPathMapService service;
                IPeer peer;
                if (Launch.this.getChannel() != null && (peer = Launch.this.getPeer()) != null && (service = (IPathMapService)ServiceManager.getInstance().getService((Object)peer, IPathMapService.class)) != null) {
                    ExecutorsUtil.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            service.applyPathMap((Object)peer, false, true, (ICallback)new Callback(){

                                protected void internalDone(Object caller, IStatus status) {
                                }
                            });
                        }
                    });
                }
            }
        });
    }
}

