/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.lm;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.launch.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.launch.core.bindings.LaunchConfigTypeBindingsManager;
import org.eclipse.tcf.te.launch.core.exceptions.LaunchServiceException;
import org.eclipse.tcf.te.launch.core.lm.LaunchConfigHelper;
import org.eclipse.tcf.te.launch.core.lm.LaunchSpecification;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchAttribute;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchManagerDelegate;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchSpecification;
import org.eclipse.tcf.te.launch.core.nls.Messages;
import org.osgi.framework.Bundle;

public class LaunchManager
extends PlatformObject {
    public static LaunchManager getInstance() {
        return LazyInstanceHolder.instance;
    }

    LaunchManager() {
    }

    public ILaunchManagerDelegate getLaunchManagerDelegate(ILaunchConfigurationType launchConfigType, String launchMode) {
        Assert.isNotNull((Object)launchConfigType);
        Assert.isNotNull((Object)launchMode);
        return LaunchConfigTypeBindingsManager.getInstance().getLaunchManagerDelegate(launchConfigType.getIdentifier(), launchMode);
    }

    public ILaunchConfigurationType getLaunchConfigType(String launchConfigTypeId, String launchMode) {
        ILaunchConfigurationType launchConfigType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(launchConfigTypeId);
        if (launchConfigType != null && !launchConfigType.supportsMode(launchMode)) {
            launchConfigType = null;
        }
        return launchConfigType;
    }

    public ILaunchConfiguration getLaunchConfiguration(ILaunchSpecification launchSpec, boolean createNew) throws LaunchServiceException {
        Assert.isNotNull((Object)launchSpec);
        ILaunchConfiguration launchConfig = null;
        try {
            String launchConfigTypeId = launchSpec.getLaunchConfigurationTypeId();
            String launchMode = launchSpec.getLaunchMode();
            ILaunchConfigurationType launchConfigType = this.getLaunchConfigType(launchConfigTypeId, launchMode);
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(launchConfigType);
            ILaunchConfiguration[] matchingConfigs = this.getLaunchManagerDelegate(launchConfigType, launchMode).getMatchingLaunchConfigurations(launchSpec, configs);
            if (matchingConfigs.length > 0) {
                launchConfig = matchingConfigs[0];
            }
        }
        catch (LaunchServiceException e) {
            if (e.getType() == 2) {
                throw e;
            }
        }
        catch (CoreException e) {
            throw new LaunchServiceException(e.getMessage());
        }
        if (createNew && launchConfig == null) {
            launchConfig = this.createOrUpdateLaunchConfiguration(null, launchSpec);
        }
        return launchConfig;
    }

    public ILaunchConfiguration createOrUpdateLaunchConfiguration(ILaunchConfiguration launchConfig, ILaunchSpecification launchSpec) throws LaunchServiceException {
        return this.createOrUpdateLaunchConfiguration(launchConfig, launchSpec, true);
    }

    public ILaunchConfiguration createOrUpdateLaunchConfiguration(ILaunchConfiguration launchConfig, ILaunchSpecification launchSpec, boolean validateSpec) throws LaunchServiceException {
        Assert.isNotNull((Object)launchSpec);
        String launchConfigTypeId = launchSpec.getLaunchConfigurationTypeId();
        String launchMode = launchSpec.getLaunchMode();
        ILaunchConfigurationType launchConfigType = this.getLaunchConfigType(launchConfigTypeId, launchMode);
        try {
            if (launchConfigType != null) {
                ILaunchManagerDelegate delegate = this.getLaunchManagerDelegate(launchConfigType, launchMode);
                if (validateSpec) {
                    delegate.validate(launchSpec);
                }
                ILaunchConfigurationWorkingCopy wc = null;
                if (launchConfig == null || !launchConfig.getType().getIdentifier().equals(launchConfigTypeId)) {
                    try {
                        wc = launchConfigType.newInstance(null, LaunchConfigHelper.getUniqueLaunchConfigName(launchSpec.getLaunchConfigName()));
                        delegate.initLaunchConfigAttributes(wc, launchSpec);
                        return wc.doSave();
                    }
                    catch (CoreException coreException) {
                        throw new LaunchServiceException(Messages.LaunchManager_error_failedToCreateConfig);
                    }
                }
                try {
                    wc = launchConfig instanceof ILaunchConfigurationWorkingCopy ? (ILaunchConfigurationWorkingCopy)launchConfig : launchConfig.getWorkingCopy();
                    delegate.updateLaunchConfigAttributes(wc, launchSpec);
                    return wc.isDirty() ? wc.doSave() : launchConfig;
                }
                catch (CoreException coreException) {
                    throw new LaunchServiceException(NLS.bind((String)Messages.LaunchManager_error_failedToUpdateConfig, (Object)launchConfig.getName()));
                }
            }
        }
        catch (CoreException coreException) {}
        throw new LaunchServiceException(NLS.bind((String)Messages.LaunchManager_error_noLaunchConfigType, (Object)launchMode));
    }

    public void deleteLaunchConfiguration(ILaunchConfiguration launchConfig) {
        if (launchConfig != null) {
            try {
                launchConfig.delete();
            }
            catch (CoreException e) {
                Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.LaunchManager_error_deleteLaunchConfig, (Throwable)e);
                Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
            }
        }
    }

    public ILaunchSpecification duplicate(ILaunchSpecification launchSpec) {
        if (launchSpec != null) {
            LaunchSpecification newLaunchSpec = new LaunchSpecification(launchSpec.getLaunchConfigurationTypeId(), launchSpec.getLaunchMode());
            if (!launchSpec.isEmpty()) {
                ILaunchAttribute[] attributes;
                ILaunchAttribute[] iLaunchAttributeArray = attributes = launchSpec.getAllAttributes();
                int n = attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchAttribute attribute = iLaunchAttributeArray[n2];
                    newLaunchSpec.addAttribute(attribute.getKey(), attribute.getValue());
                    ++n2;
                }
            }
            return newLaunchSpec;
        }
        return null;
    }

    public boolean validate(ILaunchConfiguration launchConfig, String launchMode) {
        try {
            if (launchMode == null) {
                boolean valid = false;
                String[] stringArray = LaunchConfigHelper.getLaunchConfigTypeModes(launchConfig.getType(), false);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String mode = stringArray[n2];
                    if (launchConfig.supportsMode(mode) && this.validate(launchConfig, mode)) {
                        valid = true;
                    }
                    ++n2;
                }
                return valid;
            }
            ILaunchManagerDelegate delegate = this.getLaunchManagerDelegate(launchConfig.getType(), launchMode);
            try {
                delegate.validate(launchMode, launchConfig);
            }
            catch (LaunchServiceException launchServiceException) {
                return false;
            }
        }
        catch (CoreException coreException) {}
        return true;
    }

    public ILaunchSpecification createSpecFromConfig(ILaunchConfiguration launchConfig, String launchMode, boolean withDefaultAttributes) throws LaunchServiceException {
        Assert.isNotNull((Object)launchConfig);
        LaunchSpecification spec = null;
        try {
            ILaunchConfigurationType type = launchConfig.getType();
            spec = new LaunchSpecification(type.getIdentifier(), launchMode);
            ILaunchManagerDelegate delegate = this.getLaunchManagerDelegate(type, launchMode);
            Map attributes = launchConfig.getAttributes();
            for (Map.Entry entry : attributes.entrySet()) {
                if (withDefaultAttributes) {
                    spec.addAttribute((String)entry.getKey(), entry.getValue());
                    continue;
                }
                Object attributeValue = entry.getValue();
                if (delegate.isDefaultAttribute((String)entry.getKey(), attributeValue, attributeValue, spec, launchConfig, launchMode)) continue;
                spec.addAttribute((String)entry.getKey(), attributeValue);
            }
        }
        catch (CoreException e) {
            spec = null;
            throw new LaunchServiceException(e);
        }
        return spec;
    }

    public ILaunch launch(ILaunchConfiguration launchConfig, String launchMode, boolean buildBeforeLaunch, IProgressMonitor monitor) throws LaunchServiceException {
        Assert.isNotNull((Object)launchConfig);
        Assert.isNotNull((Object)launchMode);
        try {
            ILaunchManagerDelegate delegate = this.getLaunchManagerDelegate(launchConfig.getType(), launchMode);
            delegate.validate(launchMode, launchConfig);
            return launchConfig.launch(launchMode, monitor, buildBeforeLaunch);
        }
        catch (CoreException e) {
            throw new LaunchServiceException(e);
        }
    }

    private static class LazyInstanceHolder {
        public static LaunchManager instance = new LaunchManager();

        private LazyInstanceHolder() {
        }
    }
}

