/*******************************************************************************
 * Copyright (c) 2014 Wind River Systems, Inc. and others. All rights reserved.
 * This program and the accompanying materials are made available under the terms
 * of the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Wind River Systems - initial API and implementation
 *******************************************************************************/

package org.eclipse.tcf.te.tcf.ui.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IDefaultContextService;
import org.eclipse.tcf.te.ui.views.handler.OpenEditorHandler;
import org.eclipse.ui.handlers.HandlerUtil;

/**
 * OpenEditorToolbarCommandHandler
 */
public class OpenEditorToolbarCommandHandler extends OpenEditorHandler {

	/* (non-Javadoc)
	 * @see org.eclipse.tcf.te.ui.views.handler.OpenEditorHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
	    openEditorOnSelection(HandlerUtil.getActiveWorkbenchWindow(event),
	    				new StructuredSelection(ServiceManager.getInstance().getService(IDefaultContextService.class).getDefaultContext(null)));

	    return null;
	}
}
