/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core.operation;

import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.remote.core.TCFFileStore;
import org.eclipse.tcf.te.tcf.remote.core.operation.PeerInfo;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFFileStoreOperation;

public final class TCFOperationPutInfo
extends TCFFileStoreOperation<Object> {
    private final boolean fSetAttribs;
    private final boolean fSetLastModified;
    private final IFileInfo fFileInfo;

    public TCFOperationPutInfo(TCFFileStore fileStore, IFileInfo info, boolean setAttribs, boolean setLastModified) {
        super(fileStore);
        this.fFileInfo = info;
        this.fSetAttribs = setAttribs;
        this.fSetLastModified = setLastModified;
    }

    protected IFileInfo getFileInfo() {
        return this.fFileInfo;
    }

    protected boolean isSetAttribs() {
        return this.fSetAttribs;
    }

    protected boolean isSetLastModified() {
        return this.fSetLastModified;
    }

    @Override
    protected void doExecute() {
        this.getFileSystem(new PeerInfo.DoneGetFileSystem(){

            @Override
            public void done(final IFileSystem fileSystem, IStatus status) {
                if (TCFOperationPutInfo.this.shallAbort(status)) {
                    return;
                }
                TCFOperationPutInfo.this.stat(fileSystem, TCFOperationPutInfo.this.getFileStore(), new IFileSystem.DoneStat(){

                    public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
                        if (TCFOperationPutInfo.this.shallAbort((Throwable)error)) {
                            return;
                        }
                        int p = attrs.permissions;
                        long mtime = attrs.mtime;
                        IFileInfo i = TCFOperationPutInfo.this.getFileInfo();
                        if (TCFOperationPutInfo.this.isSetAttribs()) {
                            boolean ro = i.getAttribute(2);
                            p = this.set(p, 256, i.getAttribute(0x400000));
                            p = this.set(p, 128, !ro && i.getAttribute(0x800000));
                            p = this.set(p, 64, i.getAttribute(0x1000000));
                            p = this.set(p, 32, i.getAttribute(0x2000000));
                            p = this.set(p, 16, !ro && i.getAttribute(0x4000000));
                            p = this.set(p, 8, i.getAttribute(0x8000000));
                            p = this.set(p, 4, i.getAttribute(0x10000000));
                            p = this.set(p, 2, !ro && i.getAttribute(0x20000000));
                            p = this.set(p, 1, i.getAttribute(0x40000000));
                        }
                        if (TCFOperationPutInfo.this.isSetLastModified()) {
                            mtime = i.getLastModified();
                        }
                        TCFOperationPutInfo.this.getFileStore().setAttributes(null);
                        IFileSystem.FileAttrs newAttrs = new IFileSystem.FileAttrs(attrs.flags, attrs.size, attrs.uid, attrs.gid, p, attrs.atime, mtime, attrs.attributes);
                        fileSystem.setstat(TCFOperationPutInfo.this.getPath(), newAttrs, new IFileSystem.DoneSetStat(){

                            public void doneSetStat(IToken token, IFileSystem.FileSystemException error) {
                                if (TCFOperationPutInfo.this.shallAbort((Throwable)error)) {
                                    return;
                                }
                                TCFOperationPutInfo.this.setResult(null);
                            }
                        });
                    }

                    private int set(int p, int flag, boolean set) {
                        return set ? p | flag : p & ~flag;
                    }
                });
            }
        });
    }
}

