/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.remote.core.Messages;
import org.eclipse.tcf.te.tcf.remote.core.TCFConnectionBase;
import org.eclipse.tcf.te.tcf.remote.core.TCFConnectionWorkingCopy;
import org.eclipse.tcf.te.tcf.remote.core.TCFFileManager;
import org.eclipse.tcf.te.tcf.remote.core.TCFProcessBuilder;
import org.eclipse.tcf.te.tcf.remote.core.TCFRemoteServices;
import org.eclipse.tcf.te.tcf.remote.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFOperationGetEnvironment;
import org.osgi.framework.Bundle;

public class TCFConnection
extends TCFConnectionBase {
    private final String fName;
    private volatile IPeerNode fPeerNode;
    private final List<IRemoteConnectionChangeListener> fListeners = new ArrayList<IRemoteConnectionChangeListener>();
    private volatile EState fState;
    private Map<String, String> fAttributes;
    private Map<String, String> fEnvironment;

    public TCFConnection(TCFRemoteServices tcfServices, IPeerNode peerNode) {
        super(tcfServices);
        this.fName = peerNode.getName();
        this.fPeerNode = peerNode;
        this.fState = peerNode.getConnectState() == 11 ? EState.OPEN : EState.CLOSED_TCF;
    }

    public TCFConnection(TCFRemoteServices tcfServices, String name) {
        super(tcfServices);
        this.fName = name;
        this.fState = EState.CLOSED_TCF;
    }

    public void setPeerNode(IPeerNode peerNode) {
        this.fPeerNode = peerNode;
        this.setConnectedTCF(peerNode.getConnectState() == 11);
    }

    public IPeerNode getPeerNode() {
        return this.fPeerNode;
    }

    public String getAddress() {
        if (this.fPeerNode == null) {
            return "0.0.0.0";
        }
        return (String)this.fPeerNode.getPeer().getAttributes().get("Host");
    }

    public Map<String, String> getAttributes() {
        if (this.fPeerNode == null) {
            return Collections.emptyMap();
        }
        if (this.fAttributes == null) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("os.name", this.fPeerNode.getPeer().getOSName());
            this.fAttributes = Collections.unmodifiableMap(attributes);
        }
        return this.fAttributes;
    }

    public IRemoteProcess getCommandShell(int flags) throws IOException {
        throw new IOException(Messages.TCFConnection_errorNoCommandShell);
    }

    public Map<String, String> getEnv() {
        if (this.fEnvironment == null && this.fPeerNode != null) {
            try {
                this.fEnvironment = (Map)new TCFOperationGetEnvironment(this.fPeerNode.getPeer()).execute(SubMonitor.convert(null));
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (CoreException e) {
                Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.TCFConnection_errorNoEnvironment, (Throwable)e));
            }
        }
        return this.fEnvironment;
    }

    public IRemoteFileManager getFileManager() {
        return new TCFFileManager(this);
    }

    public String getName() {
        return this.fName;
    }

    public int getPort() {
        if (this.fPeerNode == null) {
            return 0;
        }
        try {
            return Integer.parseInt((String)this.fPeerNode.getPeer().getAttributes().get("Port"));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public IRemoteProcessBuilder getProcessBuilder(List<String> command) {
        return new TCFProcessBuilder(this, command);
    }

    public IRemoteProcessBuilder getProcessBuilder(String ... command) {
        return new TCFProcessBuilder(this, command);
    }

    public String getUsername() {
        if (this.fPeerNode == null) {
            return null;
        }
        return (String)this.fPeerNode.getPeer().getAttributes().get("UserName");
    }

    public IRemoteConnectionWorkingCopy getWorkingCopy() {
        return new TCFConnectionWorkingCopy(this);
    }

    public boolean isOpen() {
        return this.fState == EState.OPEN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        if (this.fPeerNode == null) {
            this.getRemoteServices().getConnectionManager().waitForInitialization(monitor);
        }
        boolean notify = false;
        boolean performOpen = false;
        TCFConnection tCFConnection = this;
        synchronized (tCFConnection) {
            if (this.fState != EState.OPEN) {
                if (this.fPeerNode.getConnectState() == 11) {
                    this.fState = EState.OPEN;
                    notify = true;
                } else {
                    this.fState = EState.CLOSED_TCF;
                    performOpen = true;
                }
            }
        }
        if (notify) {
            this.fireConnectionChangeEvent(2);
        } else if (performOpen) {
            this.getRemoteServices().getConnectionManager().open(this.fPeerNode, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean notify = false;
        TCFConnection tCFConnection = this;
        synchronized (tCFConnection) {
            if (this.fState == EState.OPEN) {
                this.fState = EState.CLOSED_REMOTE_SERVICES;
                notify = true;
            }
        }
        if (notify) {
            this.fireConnectionChangeEvent(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setConnectedTCF(boolean connected) {
        int notify = -1;
        TCFConnection tCFConnection = this;
        synchronized (tCFConnection) {
            if (connected) {
                if (this.fState == EState.CLOSED_TCF) {
                    this.fState = EState.OPEN;
                    notify = 2;
                }
            } else if (this.fState == EState.OPEN) {
                this.fState = EState.CLOSED_TCF;
                notify = 1;
            }
        }
        if (notify != -1) {
            this.fireConnectionChangeEvent(notify);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        List<IRemoteConnectionChangeListener> list = this.fListeners;
        synchronized (list) {
            if (!this.fListeners.contains(listener)) {
                this.fListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        List<IRemoteConnectionChangeListener> list = this.fListeners;
        synchronized (list) {
            this.fListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRemoteConnectionChangeListener[] getListeners() {
        List<IRemoteConnectionChangeListener> list = this.fListeners;
        synchronized (list) {
            return this.fListeners.toArray(new IRemoteConnectionChangeListener[this.fListeners.size()]);
        }
    }

    public void fireConnectionChangeEvent(final int type) {
        final TCFConnection connection = this;
        new Job(Messages.TCFConnection_notifyListeners){

            protected IStatus run(IProgressMonitor monitor) {
                IRemoteConnectionChangeEvent event = new IRemoteConnectionChangeEvent(){

                    public IRemoteConnection getConnection() {
                        return connection;
                    }

                    public int getType() {
                        return type;
                    }
                };
                IRemoteConnectionChangeListener[] iRemoteConnectionChangeListenerArray = TCFConnection.this.getListeners();
                int n = iRemoteConnectionChangeListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IRemoteConnectionChangeListener listener = iRemoteConnectionChangeListenerArray[n2];
                    listener.connectionChanged(event);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private static enum EState {
        OPEN,
        CLOSED_TCF,
        CLOSED_REMOTE_SERVICES;

    }
}

