/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.properties;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.ui.FortranUIPlugin;
import org.eclipse.photran.internal.ui.properties.FortranBooleanFieldEditor;
import org.eclipse.photran.internal.ui.properties.FortranPropertyPage;
import org.eclipse.photran.internal.ui.properties.Messages;
import org.eclipse.photran.internal.ui.properties.WorkspacePathEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SearchPathsPropertyPage
extends FortranPropertyPage {
    private FortranBooleanFieldEditor enableVPG;
    private FortranBooleanFieldEditor enableDeclView;
    private FortranBooleanFieldEditor enableContentAssist;
    private FortranBooleanFieldEditor enableHoverTip;
    private WorkspacePathEditor modulePathEditor;
    private WorkspacePathEditor includePathEditor;
    private SearchPathProperties properties;

    protected Control createContents(Composite parent) {
        IProject proj = this.getProjectFromElement();
        if (proj == null) {
            Label lbl = new Label(parent, 0);
            lbl.setText(Messages.SearchPathsPropertyPage_SettingsNotAvailable);
            return lbl;
        }
        this.properties = new SearchPathProperties(proj);
        IPreferenceStore scopedStore = this.properties.getPropertyStore();
        scopedStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SearchPathsPropertyPage.this.setDirty();
            }
        });
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        Label l = new Label(composite, 64);
        l.setText(Messages.SearchPathsPropertyPage_EnableButtonsDescription);
        l.setLayoutData((Object)new GridData(4, 128, true, false));
        this.enableVPG = new FortranBooleanFieldEditor("EnableVPG", Messages.SearchPathsPropertyPage_EnableAnalysisRefactoring, composite){

            protected void valueChanged(boolean oldValue, boolean newValue) {
                SearchPathsPropertyPage.this.enableDeclView.setEnabled(newValue, composite);
                SearchPathsPropertyPage.this.enableContentAssist.setEnabled(newValue, composite);
                SearchPathsPropertyPage.this.enableHoverTip.setEnabled(newValue, composite);
                SearchPathsPropertyPage.this.enableDeclView.setValue(newValue);
                SearchPathsPropertyPage.this.enableContentAssist.setValue(newValue);
                SearchPathsPropertyPage.this.enableHoverTip.setValue(newValue);
            }
        };
        this.enableVPG.setPreferenceStore(scopedStore);
        this.enableVPG.load();
        this.properties.setProperty(proj, "EnableVPG", String.valueOf(this.enableVPG.getBooleanValue()));
        this.enableDeclView = new FortranBooleanFieldEditor("EnableDeclView", Messages.SearchPathsPropertyPage_EnableDeclarationView, composite);
        this.enableDeclView.setPreferenceStore(scopedStore);
        this.enableDeclView.load();
        this.enableContentAssist = new FortranBooleanFieldEditor("EnableContentAssist", Messages.SearchPathsPropertyPage_EnableContentAssist, composite);
        this.enableContentAssist.setPreferenceStore(scopedStore);
        this.enableContentAssist.load();
        this.enableHoverTip = new FortranBooleanFieldEditor("EnableHoverTip", Messages.SearchPathsPropertyPage_EnableHoverTips, composite);
        this.enableHoverTip.setPreferenceStore(scopedStore);
        this.enableHoverTip.load();
        this.enableDeclView.setEnabled(this.enableVPG.getBooleanValue(), composite);
        this.enableContentAssist.setEnabled(this.enableVPG.getBooleanValue(), composite);
        this.enableHoverTip.setEnabled(this.enableVPG.getBooleanValue(), composite);
        l = new Label(composite, 64);
        l.setLayoutData((Object)new GridData(4, 128, true, true));
        l = new Label(composite, 64);
        l.setText(Messages.SearchPathsPropertyPage_PathsDescription);
        l.setLayoutData((Object)new GridData(4, 128, true, false));
        this.modulePathEditor = new WorkspacePathEditor(this.getProjectFromElement(), "FortranModulePaths", Messages.SearchPathsPropertyPage_FoldersToBeSearchedForModules, Messages.SearchPathsPropertyPage_SelectAFolderToBeSearchedForModules, composite);
        this.modulePathEditor.setPreferenceStore(scopedStore);
        this.modulePathEditor.load();
        this.includePathEditor = new WorkspacePathEditor(this.getProjectFromElement(), "FortranIncludePaths", Messages.SearchPathsPropertyPage_FoldersToBeSearchedForIncludes, Messages.SearchPathsPropertyPage_SelectAFolderToBeSearchedForIncludes, composite);
        this.includePathEditor.setPreferenceStore(scopedStore);
        this.includePathEditor.load();
        return composite;
    }

    public void performDefaults() {
        this.enableVPG.loadDefault();
        this.enableDeclView.loadDefault();
        this.enableContentAssist.loadDefault();
        this.enableHoverTip.loadDefault();
        this.modulePathEditor.loadDefault();
        this.includePathEditor.loadDefault();
    }

    public boolean doPerformOk() {
        this.enableVPG.store();
        this.enableDeclView.store();
        this.enableContentAssist.store();
        this.enableHoverTip.store();
        this.modulePathEditor.store();
        this.includePathEditor.store();
        try {
            this.properties.save();
        }
        catch (IOException e) {
            FortranUIPlugin.log((Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SearchPathsPropertyPage_ErrorSavingProperties, (String)(String.valueOf(Messages.SearchPathsPropertyPage_PropertiesCouldNotBeSaved) + "\n" + e.getClass().getName() + ": " + e.getMessage()));
        }
        PhotranVPG.getInstance().queueJobToEnsureVPGIsUpToDate();
        return true;
    }
}

