/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.net.Inet4Address;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.php.internal.core.util.NetworkUtil;
import org.eclipse.php.internal.debug.core.PHPDebugUtil;
import org.eclipse.php.internal.server.core.Server;

public class ZendDebuggerHostProposalComputer {
    private Server server;
    private String serverTypeId;
    private boolean computeAddress;
    private Inet4Address serverHostAddress;

    public String computeProposals(Server server) {
        this.computeAddress = true;
        this.server = server;
        this.serverTypeId = server.getAttribute("serverType", null);
        String proposals = null;
        proposals = this.computeByServerType();
        if (proposals != null) {
            return proposals;
        }
        return this.computeByServerAddress();
    }

    private Inet4Address fetchHostAddress() {
        if (this.computeAddress) {
            URL address;
            this.computeAddress = false;
            try {
                address = new URL(this.server.getBaseURL());
            }
            catch (MalformedURLException e) {
                return null;
            }
            String serverHost = address.getHost();
            Inet4Address hostAddress = NetworkUtil.getByName((String)serverHost, (int)2000);
            if (!(hostAddress instanceof Inet4Address)) {
                return null;
            }
            this.serverHostAddress = hostAddress;
        }
        return this.serverHostAddress;
    }

    private String computeByServerType() {
        if (this.serverTypeId == null) {
            return null;
        }
        Inet4Address serverHostAddress = this.fetchHostAddress();
        if (serverHostAddress == null) {
            return null;
        }
        if (4 == NetworkUtil.getType((Inet4Address)serverHostAddress)) {
            return this.getPrivateAddressProposals(serverHostAddress);
        }
        return null;
    }

    private String computeByServerAddress() {
        Inet4Address serverHostAddress = this.fetchHostAddress();
        if (serverHostAddress == null) {
            return null;
        }
        switch (NetworkUtil.getType((Inet4Address)serverHostAddress)) {
            case 1: {
                return this.getPublicAddressProposal();
            }
            case 4: {
                return this.getLocalAddressProposal();
            }
            case 2: {
                return this.getPrivateAddressProposals(serverHostAddress);
            }
        }
        return null;
    }

    private String getLocalAddressProposal() {
        return NetworkUtil.LOCALHOST.getHostAddress();
    }

    private String getPrivateAddressProposals(final Inet4Address serverHostAddress) {
        List privateAddresses = NetworkUtil.getPrivateAddresses();
        if (privateAddresses.isEmpty()) {
            return null;
        }
        Collections.sort(privateAddresses, new Comparator<Inet4Address>(){

            @Override
            public int compare(Inet4Address a1, Inet4Address a2) {
                if (NetworkUtil.isSamePrivateClass((Inet4Address)a1, (Inet4Address)serverHostAddress) && !NetworkUtil.isSamePrivateClass((Inet4Address)a2, (Inet4Address)serverHostAddress)) {
                    return 1;
                }
                if (NetworkUtil.isSamePrivateClass((Inet4Address)a2, (Inet4Address)serverHostAddress) && !NetworkUtil.isSamePrivateClass((Inet4Address)a1, (Inet4Address)serverHostAddress)) {
                    return -1;
                }
                return 0;
            }
        });
        String[] hosts = new String[privateAddresses.size()];
        int i = 0;
        while (i < privateAddresses.size()) {
            hosts[i] = ((Inet4Address)privateAddresses.get(i)).getHostAddress();
            ++i;
        }
        return PHPDebugUtil.getZendHostsString(hosts);
    }

    private String getPublicAddressProposal() {
        Inet4Address publicAddress = NetworkUtil.getPublicAddress();
        if (publicAddress != null) {
            return publicAddress.getHostAddress();
        }
        return null;
    }
}

